/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.math.BigDecimal;
import java.util.List;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.AbstractFunction;

public class Abs
extends AbstractFunction {
    public static final String FUNCTION_NAME = "abs";
    protected Operand operand;

    public Abs(List<Operand> parameters) {
        super(FUNCTION_NAME, 1, parameters);
        this.operand = parameters.get(0);
    }

    @Override
    protected Object innerOperate(EntityMap entityMap) {
        Object obj = this.operand.operate(entityMap);
        return this.innerOperateProc(obj);
    }

    protected Object innerOperateProc(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Double || obj instanceof Float) {
            Number num = (Number)obj;
            double val = num.doubleValue();
            return Math.abs(val);
        }
        if (obj instanceof Long || obj instanceof Integer) {
            Number num = (Number)obj;
            long val = num.longValue();
            return Math.abs(val);
        }
        if (obj instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)obj;
            return bigDecimal.abs();
        }
        try {
            Long val = Long.valueOf(obj.toString());
            return Math.abs(val);
        }
        catch (NumberFormatException e) {
            Double val = Double.valueOf(obj.toString());
            return Math.abs(val);
        }
    }

    @Override
    protected Object innerOperate(Object[] entityArray) {
        Object obj = this.operand.operate(entityArray);
        return this.innerOperateProc(obj);
    }
}

