/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.factory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.MoqlException;
import org.datayoo.moql.Operand;
import org.datayoo.moql.antlr.OperandLexer;
import org.datayoo.moql.antlr.OperandParser;
import org.datayoo.moql.operand.OperandFactory;
import org.datayoo.moql.operand.PseudoOperand;
import org.datayoo.moql.operand.expression.member.MemberVisitor;
import org.datayoo.moql.operand.function.factory.FunctionFactory;
import org.datayoo.moql.operand.function.factory.FunctionFactoryImpl;
import org.datayoo.moql.util.StringFormater;

public class OperandFactoryImpl
implements OperandFactory {
    protected FunctionFactory functionFactory = new FunctionFactoryImpl();
    protected Set<MemberVisitor> memberVisitors = new HashSet<MemberVisitor>();

    @Override
    public Operand createOperand(String operand) throws MoqlException {
        Validate.notEmpty((CharSequence)operand, (String)"Parameter 'operand' is empty!", (Object[])new Object[0]);
        Operand pseudoOperand = OperandFactoryImpl.createPseudoOperand(operand);
        if (pseudoOperand != null) {
            return pseudoOperand;
        }
        try {
            ANTLRInputStream is = new ANTLRInputStream((InputStream)new ByteArrayInputStream(operand.getBytes()));
            OperandLexer lexer = new OperandLexer((CharStream)is);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            OperandParser parser = new OperandParser((TokenStream)tokens);
            parser.setFunctionFactory(this.functionFactory);
            parser.setMemberVisitors(this.memberVisitors);
            return parser.operand();
        }
        catch (Exception e) {
            throw new MoqlException(StringFormater.format((String)"Create operand '{}' failed!", (Object[])new Object[]{operand}), (Throwable)e);
        }
    }

    protected static Operand createPseudoOperand(String operand) {
        if (operand.endsWith(".*") || operand.equals("*")) {
            return new PseudoOperand(operand);
        }
        return null;
    }

    @Override
    public String registFunction(String name, String className) {
        return this.functionFactory.registFunction(name, className);
    }

    @Override
    public String forceRegistFunction(String name, String className) {
        return this.functionFactory.forceRegistFunction(name, className);
    }

    @Override
    public String registFunction(String name, String className, ClassLoader classLoader) {
        return this.functionFactory.registFunction(name, className, classLoader);
    }

    @Override
    public String forceRegistFunction(String name, String className, ClassLoader classLoader) {
        return this.functionFactory.forceRegistFunction(name, className, classLoader);
    }

    @Override
    public String unregistFunction(String name) {
        return this.functionFactory.unregistFunction(name);
    }

    @Override
    public void addMemberVisitor(MemberVisitor memberVisitor) {
        this.memberVisitors.add(memberVisitor);
    }

    @Override
    public boolean removeMemberVisitor(MemberVisitor memberVisitor) {
        return this.memberVisitors.remove(memberVisitor);
    }
}

