/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.relation;

import org.apache.commons.lang3.Validate;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.expression.OperationExpression;
import org.datayoo.moql.operand.expression.relation.BetweenExpression;
import org.datayoo.moql.operand.expression.relation.EqualExpression;
import org.datayoo.moql.operand.expression.relation.ExistsExpression;
import org.datayoo.moql.operand.expression.relation.GreatAndEqualExpression;
import org.datayoo.moql.operand.expression.relation.GreatThanExpression;
import org.datayoo.moql.operand.expression.relation.InExpression;
import org.datayoo.moql.operand.expression.relation.IsExpression;
import org.datayoo.moql.operand.expression.relation.LikeExpression;
import org.datayoo.moql.operand.expression.relation.LittleAndEqualExpression;
import org.datayoo.moql.operand.expression.relation.LittleThanExpression;
import org.datayoo.moql.operand.expression.relation.NotEqualExpression;
import org.datayoo.moql.operand.expression.relation.OperandExpression;
import org.datayoo.moql.util.StringFormater;

public abstract class RelationExpressionFactory {
    public static OperationExpression createRelationExpression(String operator, Operand lOperand, Operand rOperand) {
        Validate.notEmpty((CharSequence)operator, (String)"Parameter 'operator' is empty!", (Object[])new Object[0]);
        if (operator.equalsIgnoreCase("=")) {
            return new EqualExpression(lOperand, rOperand);
        }
        if (operator.equalsIgnoreCase("<")) {
            return new LittleThanExpression(lOperand, rOperand);
        }
        if (operator.equalsIgnoreCase(">")) {
            return new GreatThanExpression(lOperand, rOperand);
        }
        if (operator.equalsIgnoreCase("<=")) {
            return new LittleAndEqualExpression(lOperand, rOperand);
        }
        if (operator.equalsIgnoreCase(">=")) {
            return new GreatAndEqualExpression(lOperand, rOperand);
        }
        if (operator.equalsIgnoreCase("<>") || operator.equalsIgnoreCase("!=")) {
            return new NotEqualExpression(lOperand, rOperand);
        }
        if (operator.equalsIgnoreCase("between")) {
            return new BetweenExpression(lOperand, rOperand);
        }
        if (operator.equalsIgnoreCase("in")) {
            return new InExpression(lOperand, rOperand);
        }
        if (operator.equalsIgnoreCase("like")) {
            return new LikeExpression(lOperand, rOperand);
        }
        if (operator.equalsIgnoreCase("is")) {
            return new IsExpression(lOperand);
        }
        if (operator.equalsIgnoreCase("exists")) {
            return new ExistsExpression(rOperand);
        }
        if (operator.equalsIgnoreCase("expr")) {
            return new OperandExpression(rOperand);
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Unsuppored operator '{}'!", (Object[])new Object[]{operator}));
    }

    public static boolean isUnary(String operator) {
        Validate.notEmpty((CharSequence)operator, (String)"Parameter 'operator' is empty!", (Object[])new Object[0]);
        if (operator.equalsIgnoreCase("exists")) {
            return true;
        }
        return operator.equalsIgnoreCase("expr");
    }
}

