/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.member;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.OperateException;
import org.datayoo.moql.operand.OperandContextArrayList;
import org.datayoo.moql.operand.OperandContextList;
import org.datayoo.moql.operand.expression.AbstractExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.member.MemberExpression;
import org.datayoo.moql.operand.expression.member.MemberVisitor;
import org.datayoo.moql.operand.variable.Variable;
import org.datayoo.moql.util.StringFormater;
import org.dom4j.Element;

public class MemberVariableExpression
extends AbstractExpression
implements MemberExpression {
    protected Variable variable;
    protected Operand target;
    protected Class<?> clazz;
    protected Field field;
    protected Map<Class<?>, Field> fieldCache = new HashMap();
    protected Set<MemberVisitor> memberVisitors = null;

    public MemberVariableExpression(Operand target, Variable variable) {
        this(target, variable, null);
    }

    public MemberVariableExpression(Operand target, Variable variable, Set<MemberVisitor> memberVisitors) {
        this.expressionType = ExpressionType.MEMBER;
        Validate.notNull((Object)target, (String)"Parameter 'target' is null!", (Object[])new Object[0]);
        Validate.notNull((Object)variable, (String)"Parameter 'variable' is null!", (Object[])new Object[0]);
        this.target = target;
        this.variable = variable;
        this.name = this.buildNameString();
        this.memberVisitors = memberVisitors;
    }

    protected String buildNameString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.target.toString());
        sbuf.append('.');
        sbuf.append(this.variable.toString());
        return sbuf.toString();
    }

    @Override
    public Operand getTarget() {
        return this.target;
    }

    @Override
    public Operand getMember() {
        return this.variable;
    }

    @Override
    public Object operate(EntityMap entityMap) {
        Object o = this.target.operate(entityMap);
        return this.operateProc(o);
    }

    protected Object operateProc(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof OperandContextList)) {
            if (o instanceof Map) {
                return this.operate((Map)o);
            }
            if (o instanceof JsonObject) {
                return this.operate((JsonObject)o);
            }
            if (o instanceof Element) {
                return this.operate((Element)o);
            }
            MemberVisitor memberVisitor = this.getVisitor(o);
            if (memberVisitor != null) {
                String name = this.variable.getName();
                return memberVisitor.operate(o, name);
            }
            return this.operate(o);
        }
        OperandContextList ctxList = (OperandContextList)o;
        OperandContextArrayList resultList = new OperandContextArrayList(ctxList.size());
        for (Object obj : ctxList) {
            Object ret = this.operate(obj);
            resultList.add(ret);
        }
        return resultList;
    }

    protected Object operate(Map map) {
        String name = this.variable.getName();
        return map.get(name);
    }

    protected Object operate(JsonObject jsonObject) {
        String name = this.variable.getName();
        JsonElement value = jsonObject.get(name);
        if (value == null || value.isJsonNull()) {
            return null;
        }
        if (value instanceof JsonPrimitive) {
            JsonPrimitive jp = (JsonPrimitive)value;
            if (jp.isString()) {
                return jp.getAsString();
            }
            if (jp.isBoolean()) {
                return jp.getAsBoolean();
            }
            if (jp.isNumber()) {
                return this.getNumber(jp);
            }
        }
        return value;
    }

    protected Object getNumber(JsonPrimitive value) {
        String v = value.getAsString();
        if (v.indexOf(46) == -1) {
            return value.getAsLong();
        }
        return value.getAsDouble();
    }

    protected Object operate(Element element) {
        String name = this.variable.getName();
        List list = element.elements(name);
        if (list == null) {
            return null;
        }
        if (list.size() > 1) {
            return list;
        }
        return list.get(0);
    }

    protected MemberVisitor getVisitor(Object o) {
        if (this.memberVisitors == null) {
            return null;
        }
        for (MemberVisitor memberVisitor : this.memberVisitors) {
            if (!memberVisitor.isVisitable(o)) continue;
            return memberVisitor;
        }
        return null;
    }

    protected Object operate(Object o) {
        if (o.getClass().isArray()) {
            return this.operateArray(o);
        }
        Field f = this.getField(o);
        try {
            return f.get(o);
        }
        catch (Exception e) {
            throw new OperateException(StringFormater.format((String)"Invoke field '{}' in class '{}' failed!", (Object[])new Object[]{this.variable.getName(), o.getClass().getName()}), e);
        }
    }

    protected Object operateArray(Object o) {
        if (this.variable.getName().equals("length")) {
            return Array.getLength(o);
        }
        throw new UnsupportedOperationException("");
    }

    protected Field getField(Object targetObject) {
        Class<?> objClazz = targetObject.getClass();
        if (this.clazz != null && objClazz.equals(this.clazz)) {
            return this.field;
        }
        Field f = this.fieldCache.get(objClazz);
        if (f == null) {
            try {
                f = objClazz.getDeclaredField(this.variable.getName());
                f.setAccessible(true);
            }
            catch (Exception e) {
                throw new OperateException(StringFormater.format((String)"Get field '{}' from class '{}' failed!", (Object[])new Object[]{this.variable.getName(), objClazz.getName()}), e);
            }
            this.fieldCache.put(objClazz, f);
            this.clazz = objClazz;
            this.field = f;
        }
        return f;
    }

    @Override
    public void bind(String[] entityNames) {
        this.target.bind(entityNames);
        this.binded = true;
    }

    @Override
    public Object operate(Object[] entityArray) {
        Object o = this.target.operate(entityArray);
        return this.operateProc(o);
    }

    @Override
    public Operand setValue(Object[] entityArray, Object value) {
        Object o = this.target.operate(entityArray);
        this.setValueProc(o, value);
        return this;
    }

    protected void setValueProc(Object o, Object value) {
        if (o == null) {
            return;
        }
        if (!(o instanceof OperandContextList)) {
            if (o instanceof Map) {
                this.setValue((Map)o, value);
                return;
            }
            if (o instanceof JsonObject) {
                this.setValue((JsonObject)o, value);
                return;
            }
            if (o instanceof Element) {
                this.setValue((Element)o, value);
                return;
            }
            MemberVisitor memberVisitor = this.getVisitor(o);
            if (memberVisitor != null) {
                String name = this.variable.getName();
                memberVisitor.setValue(o, name, value);
                return;
            }
            this.setValue(o, value);
        }
    }

    protected void setValue(Map map, Object value) {
        String name = this.variable.getName();
        map.put(name, value);
    }

    protected void setValue(JsonObject jsonObject, Object value) {
        String name = this.variable.getName();
        jsonObject.remove(name);
        if (value == null) {
            jsonObject.add(name, (JsonElement)JsonNull.INSTANCE);
            return;
        }
        if (value instanceof String) {
            jsonObject.addProperty(name, (String)value);
        } else if (value instanceof Number) {
            jsonObject.addProperty(name, (Number)value);
        } else if (value instanceof Boolean) {
            jsonObject.addProperty(name, (Boolean)value);
        } else {
            jsonObject.addProperty(name, value.toString());
        }
    }

    protected void setValue(Element element, Object value) {
        if (value == null) {
            return;
        }
        String name = this.variable.getName();
        List list = element.elements(name);
        if (list == null) {
            return;
        }
        if (list.size() > 1) {
            for (Object o : list) {
                Element e = (Element)o;
                ((Element)o).setText(value.toString());
            }
            return;
        }
        ((Element)list.get(0)).setText(value.toString());
    }

    protected void setValue(Object o, Object value) {
        if (o instanceof Map) {
            ((Map)o).put(this.variable.getName(), value);
        }
        Field f = this.getField(o);
        try {
            f.set(o, value);
        }
        catch (Exception e) {
            throw new OperateException(StringFormater.format((String)"Invoke field '{}' in class '{}' failed!", (Object[])new Object[]{this.variable.getName(), o.getClass().getName()}), e);
        }
    }

    @Override
    public Operand setValue(EntityMap entityMap, Object value) {
        Object o = this.target.operate(entityMap);
        this.setValueProc(o, value);
        return this;
    }
}

