/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.logic;

import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.metadata.OperatorType;
import org.datayoo.moql.operand.expression.AbstractOperationExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.logic.LogicOperator;

public class OrExpression
extends AbstractOperationExpression {
    public OrExpression(Operand lOperand, Operand rOperand) {
        super(OperatorType.BINARY, LogicOperator.OR, lOperand, rOperand);
        this.expressionType = ExpressionType.LOGIC;
    }

    @Override
    public Object operate(EntityMap entityMap) {
        return this.booleanOperate(entityMap);
    }

    @Override
    public boolean booleanOperate(EntityMap entityMap) {
        boolean lValue = this.lOperand.booleanOperate(entityMap);
        boolean rValue = this.rOperand.booleanOperate(entityMap);
        return lValue || rValue;
    }

    @Override
    public Object operate(Object[] entityArray) {
        boolean lValue = OrExpression.isTrue(this.lOperand.operate(entityArray));
        boolean rValue = OrExpression.isTrue(this.rOperand.operate(entityArray));
        return lValue || rValue;
    }
}

