/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.bit;

import org.datayoo.moql.EntityMap;
import org.datayoo.moql.NumberConvertable;
import org.datayoo.moql.Operand;
import org.datayoo.moql.metadata.OperatorType;
import org.datayoo.moql.operand.expression.AbstractOperationExpression;
import org.datayoo.moql.operand.expression.bit.BitwiseOperator;
import org.datayoo.moql.util.StringFormater;

public class BitwiseNotExpression
extends AbstractOperationExpression {
    protected Object constantReturnValue;

    public BitwiseNotExpression(Operand operand) {
        super(OperatorType.UNARY, BitwiseOperator.BITWISENOT, null, operand);
        this.initializeBitwise();
    }

    protected void initializeBitwise() {
        Long rNumber = null;
        if (this.rOperand.isConstantReturn()) {
            Object num = this.rOperand.operate(this.entityMap);
            rNumber = this.getNumber(this.rOperand, num);
        }
        if (rNumber != null) {
            this.constantReturn = true;
            this.constantReturnValue = rNumber ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    protected Long getNumber(Operand operand, Object obj) {
        Number num;
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof NumberConvertable && (num = ((NumberConvertable)obj).toNumber()) != null && (num instanceof Long || num instanceof Integer || num instanceof Short || num instanceof Byte)) {
            return num.longValue();
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Operand '{}' is not a number!", (Object[])new Object[]{operand.toString()}));
    }

    @Override
    public Object operate(EntityMap entityMap) {
        if (this.constantReturn) {
            return this.constantReturnValue;
        }
        Object num = this.rOperand.operate(entityMap);
        Long rNumber = this.getNumber(this.rOperand, num);
        if (rNumber == null) {
            return null;
        }
        return rNumber ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public Object operate(Object[] entityArray) {
        if (this.constantReturn) {
            return this.constantReturnValue;
        }
        Object num = this.rOperand.operate(entityArray);
        Long rNumber = this.getNumber(this.rOperand, num);
        if (rNumber == null) {
            return null;
        }
        return rNumber ^ 0xFFFFFFFFFFFFFFFFL;
    }
}

