/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.array;

import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.Objects;
import org.datayoo.moql.NumberConvertable;
import org.datayoo.moql.operand.OperandContextArrayList;
import org.datayoo.moql.operand.OperandContextList;
import org.datayoo.moql.operand.expression.array.ArrayAccessor;
import org.datayoo.moql.util.StringFormater;

public class SystemArrayAccessor
implements ArrayAccessor {
    @Override
    public Object getObject(Object array, Object index) {
        if (index instanceof Number) {
            return Array.get(array, ((Number)index).intValue());
        }
        if (index instanceof NumberConvertable) {
            Number inx = ((NumberConvertable)index).toNumber();
            return Array.get(array, inx.intValue());
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Unsupport 'index' of class '{}'!", (Object[])new Object[]{index.getClass().getName()}));
    }

    @Override
    public void setObject(Object array, Object index, Object value) {
        if (index instanceof Number) {
            Array.set(array, ((Number)index).intValue(), value);
            return;
        }
        if (index instanceof NumberConvertable) {
            Number inx = ((NumberConvertable)index).toNumber();
            Array.set(array, inx.intValue(), value);
            return;
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Unsupport 'index' of class '{}'!", (Object[])new Object[]{index.getClass().getName()}));
    }

    @Override
    public Object removeObject(Object array, Object value) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object n = Array.get(array, i);
            if (Objects.equals(n, value)) continue;
            list.add(n);
        }
        Object ary = Array.newInstance(array.getClass().getComponentType(), list.size());
        int i = 0;
        for (Object e : list) {
            Array.set(ary, i++, e);
        }
        return ary;
    }

    @Override
    public OperandContextList toOperandContextList(Object array) {
        OperandContextArrayList ctxList = new OperandContextArrayList(Array.getLength(array));
        for (int i = 0; i < Array.getLength(array); ++i) {
            ctxList.add(Array.get(array, i));
        }
        return ctxList;
    }

    @Override
    public int getSize(Object array) {
        return Array.getLength(array);
    }
}

