/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.array;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.datayoo.moql.NumberConvertable;
import org.datayoo.moql.OperateException;
import org.datayoo.moql.operand.OperandContextLinkedList;
import org.datayoo.moql.operand.OperandContextList;
import org.datayoo.moql.operand.expression.array.ArrayAccessor;
import org.datayoo.moql.util.StringFormater;

public class ResultSetAccessor
implements ArrayAccessor {
    @Override
    public Object getObject(Object array, Object index) {
        ResultSet rs = (ResultSet)array;
        if (index instanceof Number) {
            return this.getObject(rs, ((Number)index).intValue());
        }
        if (index.getClass().equals(String.class)) {
            return this.getColumn(rs, (String)index);
        }
        if (index instanceof NumberConvertable) {
            Number inx = ((NumberConvertable)index).toNumber();
            return this.getObject(rs, inx.intValue());
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Unsupport 'index' of class '{}'!", (Object[])new Object[]{index.getClass().getName()}));
    }

    @Override
    public void setObject(Object array, Object index, Object value) {
        throw new UnsupportedOperationException("The array of ResultSet doesn't support set object!");
    }

    protected Object getObject(ResultSet rs, int index) {
        int i = 0;
        try {
            while (rs.next()) {
                if (i++ != index) continue;
                return this.getRecord(rs);
            }
            rs.first();
        }
        catch (SQLException e) {
            throw new OperateException(e);
        }
        throw new IndexOutOfBoundsException();
    }

    protected Map<String, Object> getRecord(ResultSet rs) throws SQLException {
        HashMap<String, Object> record = new HashMap<String, Object>();
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            record.put(metadata.getCatalogName(i), rs.getObject(i));
        }
        return record;
    }

    protected List<Object> getColumn(ResultSet rs, String columnName) {
        LinkedList<Object> data = new LinkedList<Object>();
        try {
            int index = rs.findColumn(columnName);
            while (rs.next()) {
                data.add(rs.getObject(index));
            }
            rs.first();
        }
        catch (SQLException e) {
            throw new OperateException(e);
        }
        return data;
    }

    @Override
    public Object removeObject(Object array, Object value) {
        throw new UnsupportedOperationException("The array of ResultSet doesn't support set object!");
    }

    @Override
    public OperandContextList toOperandContextList(Object array) {
        ResultSet rs = (ResultSet)array;
        OperandContextLinkedList ctxList = new OperandContextLinkedList();
        try {
            while (rs.next()) {
                ctxList.add(this.getRecord(rs));
            }
        }
        catch (SQLException e) {
            throw new OperateException(e);
        }
        return ctxList;
    }

    @Override
    public int getSize(Object array) {
        ResultSet rs = (ResultSet)array;
        try {
            return rs.getFetchSize();
        }
        catch (SQLException e) {
            throw new OperateException(e);
        }
    }
}

