/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.array;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.datayoo.moql.NumberConvertable;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.operand.OperandContextArrayList;
import org.datayoo.moql.operand.OperandContextList;
import org.datayoo.moql.operand.expression.array.ArrayAccessor;
import org.datayoo.moql.util.StringFormater;

public class RecordSetAccessor
implements ArrayAccessor {
    @Override
    public Object getObject(Object array, Object index) {
        RecordSet rs = (RecordSet)array;
        if (index instanceof Number) {
            return rs.getRecordAsMap(((Number)index).intValue());
        }
        if (index.getClass().equals(String.class)) {
            return rs.getColumn((String)index);
        }
        if (index instanceof NumberConvertable) {
            Number inx = ((NumberConvertable)index).toNumber();
            return rs.getRecordAsMap(inx.intValue());
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Unsupport 'index' of class '{}'!", (Object[])new Object[]{index.getClass().getName()}));
    }

    @Override
    public void setObject(Object array, Object index, Object value) {
        throw new UnsupportedOperationException("The array of RecordSet doesn't support set object!");
    }

    @Override
    public Object removeObject(Object array, Object value) {
        RecordSet rs = (RecordSet)array;
        Iterator<Object[]> it = rs.getRecords().iterator();
        while (it.hasNext()) {
            Object[] n = it.next();
            if (!Objects.equals(n, value)) continue;
            it.remove();
        }
        return array;
    }

    @Override
    public OperandContextList toOperandContextList(Object array) {
        RecordSet rs = (RecordSet)array;
        return new OperandContextArrayList((Collection<? extends Object>)rs.getRecordsAsMaps());
    }

    @Override
    public int getSize(Object array) {
        RecordSet rs = (RecordSet)array;
        return rs.getRecordsCount();
    }
}

