/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Objects;
import org.datayoo.moql.NumberConvertable;
import org.datayoo.moql.operand.OperandContextArrayList;
import org.datayoo.moql.operand.OperandContextList;
import org.datayoo.moql.operand.expression.array.ArrayAccessor;
import org.datayoo.moql.util.StringFormater;

public class JsonArrayAccessor
implements ArrayAccessor {
    @Override
    public Object getObject(Object array, Object index) {
        JsonArray jsonArray = (JsonArray)array;
        if (index instanceof Number) {
            return jsonArray.get(((Number)index).intValue());
        }
        if (index instanceof NumberConvertable) {
            Number inx = ((NumberConvertable)index).toNumber();
            return jsonArray.get(inx.intValue());
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Unsupport 'index' of class '{}'!", (Object[])new Object[]{index.getClass().getName()}));
    }

    @Override
    public void setObject(Object array, Object index, Object value) {
        JsonArray jsonArray = (JsonArray)array;
        if (index instanceof Number) {
            jsonArray.set(((Number)index).intValue(), this.toJsonElement(value));
            return;
        }
        if (index instanceof NumberConvertable) {
            Number inx = ((NumberConvertable)index).toNumber();
            jsonArray.set(inx.intValue(), this.toJsonElement(value));
            return;
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Unsupport 'index' of class '{}'!", (Object[])new Object[]{index.getClass().getName()}));
    }

    protected JsonElement toJsonElement(Object value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        if (value instanceof Number) {
            return new JsonPrimitive((Number)value);
        }
        if (value instanceof Boolean) {
            return new JsonPrimitive((Boolean)value);
        }
        return new JsonPrimitive(value.toString());
    }

    @Override
    public Object removeObject(Object array, Object value) {
        JsonArray jsonArray = (JsonArray)array;
        Iterator it = jsonArray.iterator();
        while (it.hasNext()) {
            Object n = it.next();
            if (!Objects.equals(n, value)) continue;
            it.remove();
        }
        return array;
    }

    @Override
    public OperandContextList toOperandContextList(Object array) {
        JsonArray jsonArray = (JsonArray)array;
        OperandContextArrayList ctxList = new OperandContextArrayList(Array.getLength(array));
        for (int i = 0; i < jsonArray.size(); ++i) {
            ctxList.add(jsonArray.get(i));
        }
        return ctxList;
    }

    @Override
    public int getSize(Object array) {
        JsonArray jsonArray = (JsonArray)array;
        return jsonArray.size();
    }
}

