/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.array;

import com.google.gson.JsonArray;
import java.sql.ResultSet;
import java.util.Map;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.operand.OperandContextList;
import org.datayoo.moql.operand.expression.array.ArrayAccessor;
import org.datayoo.moql.operand.expression.array.ElementAttrAccessor;
import org.datayoo.moql.operand.expression.array.IteratorAccessor;
import org.datayoo.moql.operand.expression.array.JsonArrayAccessor;
import org.datayoo.moql.operand.expression.array.MapAccessor;
import org.datayoo.moql.operand.expression.array.RecordSetAccessor;
import org.datayoo.moql.operand.expression.array.ResultSetAccessor;
import org.datayoo.moql.operand.expression.array.SystemArrayAccessor;
import org.datayoo.moql.util.StringFormater;
import org.dom4j.Element;

public class ArrayExpressionUtils {
    protected static final ArrayAccessor arrayAccessor = new SystemArrayAccessor();
    protected static final JsonArrayAccessor jsonArrayAccessor = new JsonArrayAccessor();
    protected static final ElementAttrAccessor elementAttrAccessor = new ElementAttrAccessor();
    protected static final ArrayAccessor mapAccessor = new MapAccessor();
    protected static final ArrayAccessor iteratorAccessor = new IteratorAccessor();
    protected static final ArrayAccessor resultSetAccessor = new ResultSetAccessor();
    protected static final ArrayAccessor recordSetAccessor = new RecordSetAccessor();

    public static ArrayAccessor getArrayAccessor(Object o) {
        if (o.getClass().isArray()) {
            return arrayAccessor;
        }
        if (o instanceof JsonArray) {
            return jsonArrayAccessor;
        }
        if (o instanceof Element) {
            return elementAttrAccessor;
        }
        if (o instanceof Map) {
            return mapAccessor;
        }
        if (o instanceof Iterable) {
            return iteratorAccessor;
        }
        if (o instanceof ResultSet) {
            return resultSetAccessor;
        }
        if (o instanceof RecordSet) {
            return recordSetAccessor;
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Unsupport class '{}'!", (Object[])new Object[]{o.getClass().getName()}));
    }

    public static boolean isArray(Object o) {
        if (o.getClass().isArray()) {
            return true;
        }
        if (o instanceof JsonArray) {
            return true;
        }
        if (o instanceof Map) {
            return true;
        }
        if (o instanceof Iterable) {
            return true;
        }
        if (o instanceof ResultSet) {
            return true;
        }
        return o instanceof RecordSet;
    }

    public static OperandContextList toOperandContextList(Object o) {
        if (o instanceof OperandContextList) {
            return (OperandContextList)o;
        }
        if (o.getClass().isArray()) {
            return arrayAccessor.toOperandContextList(o);
        }
        if (o instanceof JsonArray) {
            return jsonArrayAccessor.toOperandContextList(o);
        }
        if (o instanceof Map) {
            return mapAccessor.toOperandContextList(o);
        }
        if (o instanceof Iterable) {
            return iteratorAccessor.toOperandContextList(o);
        }
        if (o instanceof ResultSet) {
            return resultSetAccessor.toOperandContextList(o);
        }
        if (o instanceof RecordSet) {
            return recordSetAccessor.toOperandContextList(o);
        }
        return null;
    }
}

