/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.arithmetic;

import org.datayoo.moql.EntityMap;
import org.datayoo.moql.NumberConvertable;
import org.datayoo.moql.Operand;
import org.datayoo.moql.metadata.OperatorType;
import org.datayoo.moql.operand.constant.ConstantType;
import org.datayoo.moql.operand.expression.AbstractOperationExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.arithmetic.ArithmeticOperator;
import org.datayoo.moql.util.StringFormater;

public abstract class AbstractArithmeticExpression
extends AbstractOperationExpression {
    protected ConstantType lOperandType;
    protected ConstantType rOperandType;
    protected Object constantReturnValue;

    public AbstractArithmeticExpression(ArithmeticOperator operator, Operand lOperand, Operand rOperand) {
        super(OperatorType.BINARY, operator, lOperand, rOperand);
        this.expressionType = ExpressionType.ARITHMETIC;
        this.initializeArithmetic();
    }

    protected void initializeArithmetic() {
        Number lNumber = null;
        Number rNumber = null;
        if (this.lOperand.isConstantReturn()) {
            lNumber = this.getNumber(this.lOperand, this.lOperand.operate((EntityMap)null));
            this.lOperandType = this.getConstantType(lNumber);
        }
        if (this.rOperand.isConstantReturn()) {
            rNumber = this.getNumber(this.rOperand, this.rOperand.operate((EntityMap)null));
            this.rOperandType = this.getConstantType(rNumber);
        }
        if (this.lOperandType != null && this.rOperandType != null) {
            this.constantReturn = true;
            this.constantReturnValue = this.calc(lNumber, rNumber, this.detemineReturnType(this.lOperandType, this.rOperandType));
        }
    }

    protected Number getNumber(Operand operand, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        if (obj instanceof NumberConvertable) {
            return ((NumberConvertable)obj).toNumber();
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Operand '{}' is not a number!", (Object[])new Object[]{operand.toString()}));
    }

    protected ConstantType getConstantType(Number number) {
        if (number instanceof Float || number instanceof Double) {
            return ConstantType.DOUBLE;
        }
        return ConstantType.LONG;
    }

    protected ConstantType detemineReturnType(ConstantType lOperandType, ConstantType rOperandType) {
        if (lOperandType == ConstantType.DOUBLE || rOperandType == ConstantType.DOUBLE) {
            return ConstantType.DOUBLE;
        }
        return ConstantType.LONG;
    }

    @Override
    public Object operate(EntityMap entityMap) {
        if (this.constantReturn) {
            return this.constantReturnValue;
        }
        Object lNum = this.lOperand.operate(entityMap);
        Object rNum = this.rOperand.operate(entityMap);
        Number lNumber = this.getNumber(this.lOperand, lNum);
        Number rNumber = this.getNumber(this.rOperand, rNum);
        if (lNumber == null || rNumber == null) {
            return null;
        }
        ConstantType lOperandType = this.getConstantType(lNumber, this.lOperandType);
        ConstantType rOperandType = this.getConstantType(rNumber, this.rOperandType);
        return this.calc(lNumber, rNumber, this.detemineReturnType(lOperandType, rOperandType));
    }

    protected ConstantType getConstantType(Number number, ConstantType initializedType) {
        if (initializedType != null) {
            return initializedType;
        }
        return this.getConstantType(number);
    }

    protected abstract Object calc(Number var1, Number var2, ConstantType var3);

    protected Object convertReturnValue(Number ret, ConstantType returnType) {
        if (returnType == ConstantType.DOUBLE) {
            return ret.doubleValue();
        }
        return ret.longValue();
    }

    @Override
    public Object operate(Object[] entityArray) {
        if (this.constantReturn) {
            return this.constantReturnValue;
        }
        Object lNum = this.lOperand.operate(entityArray);
        Object rNum = this.rOperand.operate(entityArray);
        Number lNumber = this.getNumber(this.lOperand, lNum);
        Number rNumber = this.getNumber(this.rOperand, rNum);
        if (lNumber == null || rNumber == null) {
            return null;
        }
        ConstantType lOperandType = this.getConstantType(lNumber, this.lOperandType);
        ConstantType rOperandType = this.getConstantType(rNumber, this.rOperandType);
        return this.calc(lNumber, rNumber, this.detemineReturnType(lOperandType, rOperandType));
    }
}

