/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.expression.AbstractExpression;
import org.datayoo.moql.operand.expression.ExpressionType;

public class RangeExpression
extends AbstractExpression {
    protected List<Operand> operands = new ArrayList<Operand>(2);
    protected boolean lClosure = false;
    protected boolean rClosure = false;

    public RangeExpression(Operand lRange, Operand rRange, boolean lClosure, boolean rClosure) {
        Validate.notNull((Object)lRange, (String)"lRange is null!", (Object[])new Object[0]);
        Validate.notNull((Object)rRange, (String)"rRange is null!", (Object[])new Object[0]);
        this.operands.add(lRange);
        this.operands.add(rRange);
        this.lClosure = lClosure;
        this.rClosure = rClosure;
        this.expressionType = ExpressionType.RANGE;
        this.name = this.buildNameString();
    }

    protected String buildNameString() {
        StringBuffer sbuf = new StringBuffer();
        if (this.lClosure) {
            sbuf.append('[');
        } else {
            sbuf.append('{');
        }
        int i = 0;
        for (Operand operand : this.operands) {
            if (i++ != 0) {
                sbuf.append(',');
            }
            sbuf.append(operand.toString());
        }
        if (this.rClosure) {
            sbuf.append(']');
        } else {
            sbuf.append('}');
        }
        return sbuf.toString();
    }

    @Override
    public Object operate(EntityMap entityMap) {
        return this.operands;
    }

    public List<Operand> getOperands() {
        return this.operands;
    }

    public boolean islClosure() {
        return this.lClosure;
    }

    public boolean isrClosure() {
        return this.rClosure;
    }

    @Override
    public void bind(String[] entityNames) {
        for (Operand operand : this.operands) {
            operand.bind(entityNames);
        }
        this.binded = true;
    }

    @Override
    public Object operate(Object[] entityArray) {
        return this.operands;
    }
}

