/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.engine;

import org.apache.commons.lang3.Validate;
import org.datayoo.moql.Filter;
import org.datayoo.moql.MoqlException;
import org.datayoo.moql.Operand;
import org.datayoo.moql.Selector;
import org.datayoo.moql.SelectorDefinition;
import org.datayoo.moql.core.factory.MoqlFactoryImpl;
import org.datayoo.moql.env.MoqlEnv;
import org.datayoo.moql.metadata.ConditionMetadata;
import org.datayoo.moql.parser.MoqlParser;
import org.datayoo.moql.util.StringFormater;

public abstract class MoqlEngine {
    protected static MoqlFactoryImpl moqlFactory = new MoqlFactoryImpl();

    public static Selector createSelector(SelectorDefinition selectorDefinition) throws MoqlException {
        Validate.notNull((Object)selectorDefinition, (String)"Parameter 'selectorDefinition' is null!", (Object[])new Object[0]);
        try {
            return moqlFactory.createSelector(selectorDefinition);
        }
        catch (Exception e) {
            throw new MoqlException("Create selector failed!", (Throwable)e);
        }
    }

    public static Selector createSelector(String moql) throws MoqlException {
        SelectorDefinition selectorDefinition = MoqlParser.parseMoql((String)moql);
        try {
            return moqlFactory.createSelector(selectorDefinition);
        }
        catch (Exception e) {
            throw new MoqlException(StringFormater.format((String)"Create selector by moql '{}' failed!", (Object[])new Object[]{moql}), (Throwable)e);
        }
    }

    public static Filter createFilter(String condition) throws MoqlException {
        ConditionMetadata conditionMetadata = MoqlParser.parseCondition((String)condition);
        try {
            return moqlFactory.createFilter(conditionMetadata);
        }
        catch (Exception e) {
            throw new MoqlException(StringFormater.format((String)"Create filter by condition '{}' failed!", (Object[])new Object[]{condition}), (Throwable)e);
        }
    }

    public static Filter createFilter(ConditionMetadata conditionMetadata) throws MoqlException {
        try {
            return moqlFactory.createFilter(conditionMetadata);
        }
        catch (Exception e) {
            throw new MoqlException(e.getMessage(), (Throwable)e);
        }
    }

    public static Operand createOperand(String operand) throws MoqlException {
        Validate.notEmpty((CharSequence)operand, (String)"Parameter 'operand' is empty!", (Object[])new Object[0]);
        try {
            return moqlFactory.getOperandFactory().createOperand(operand);
        }
        catch (Exception e) {
            throw new MoqlException(StringFormater.format((String)"Create operand '{}' failed!", (Object[])new Object[]{operand}), (Throwable)e);
        }
    }

    public static String registFunction(String name, String className) {
        return moqlFactory.getOperandFactory().registFunction(name, className);
    }

    public static String unregistFunction(String name) {
        return moqlFactory.getOperandFactory().unregistFunction(name);
    }

    static {
        MoqlEnv.putEnvProp("org.moql.operandfactory", moqlFactory.getOperandFactory());
    }
}

