/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.data;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.data.Counter;
import org.datayoo.moql.data.FeatureDecisionor;

public class ColumnFeature
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected FeatureDecisionor featureDecisionor;
    protected Class<?> type;
    protected Map<Object, Counter> valueCounters = new HashMap<Object, Counter>();
    protected int count = 0;
    protected boolean dimension = true;

    public ColumnFeature(String name, FeatureDecisionor featureDecisionor) {
        Validate.notEmpty((CharSequence)name, (String)"name is empty!", (Object[])new Object[0]);
        Validate.notNull((Object)featureDecisionor, (String)"featureDecisionor is empty!", (Object[])new Object[0]);
        this.name = name;
        this.featureDecisionor = featureDecisionor;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public synchronized Map<Object, Counter> getValueCounters() {
        return this.valueCounters;
    }

    public synchronized Set<Object> getValues() {
        return this.valueCounters.keySet();
    }

    public synchronized void addValue(Object value) {
        if (!this.dimension) {
            return;
        }
        if (value == null) {
            value = "null";
        } else {
            this.setType(value);
        }
        Counter counter = this.valueCounters.get(value);
        if (counter == null) {
            counter = new Counter();
            counter.increment();
            this.valueCounters.put(value, counter);
        } else {
            counter.increment();
        }
        ++this.count;
        if (this.featureDecisionor.isReady(this.count)) {
            this.dimension = this.featureDecisionor.isDimension(this.getRatioOfVR());
        }
    }

    public double getRatioOfVR() {
        return (double)this.valueCounters.size() / (double)this.count;
    }

    protected void setType(Object value) {
        if (this.type != null && this.type != value.getClass()) {
            value.getClass().isAssignableFrom(this.type);
        } else {
            this.type = value.getClass();
        }
    }

    public boolean isDimension() {
        return this.dimension;
    }
}

