/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core.combination;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.RecordSetDefinition;
import org.datayoo.moql.core.RecordSetImpl;
import org.datayoo.moql.core.combination.AbstractRecordSetCombination;
import org.datayoo.moql.core.combination.RecordComparator;
import org.datayoo.moql.core.combination.RecordTranslator;
import org.datayoo.moql.metadata.ColumnMetadata;
import org.datayoo.moql.metadata.ColumnsMetadata;

public class Union
extends AbstractRecordSetCombination {
    public Union(ColumnsMetadata columnsMetadata) {
        super(columnsMetadata);
    }

    @Override
    protected RecordSet combine(boolean all, RecordSet lRecordSet, RecordSet rRecordSet) {
        int[] mappingIndexes = this.getColumnsMapping(lRecordSet.getRecordSetDefinition().getColumns(), rRecordSet.getRecordSetDefinition().getColumns());
        int[] indexes = this.createSequenceIndexes(lRecordSet.getRecordSetDefinition().getColumns().size());
        RecordComparator comparator = new RecordComparator(indexes, mappingIndexes);
        RecordTranslator translator = new RecordTranslator(mappingIndexes);
        ArrayList<Object[]> result = new ArrayList<Object[]>(lRecordSet.getRecordsCount() + rRecordSet.getRecordsCount());
        if (!all) {
            this.distinct(lRecordSet.getRecords(), result);
            for (Object[] record : rRecordSet.getRecords()) {
                if (this.existRecord(record, result, comparator)) continue;
                result.add(translator.translate(record));
            }
        } else {
            result.addAll(lRecordSet.getRecords());
            for (Object[] record : rRecordSet.getRecords()) {
                result.add(translator.translate(record));
            }
        }
        return new RecordSetImpl(lRecordSet.getRecordSetDefinition(), this.getStart(lRecordSet.getStart(), rRecordSet.getStart()), this.getEnd(lRecordSet.getEnd(), rRecordSet.getEnd()), result);
    }

    protected void distinct(List<Object[]> records, List<Object[]> result) {
        for (Object[] record : records) {
            boolean add = true;
            for (Object[] r : result) {
                if (!this.equals(record, r)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            result.add(record);
        }
    }

    protected boolean equals(Object[] record1, Object[] record2) {
        for (int i = 0; i < record1.length; ++i) {
            if (Objects.equals(record1[i], record2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected RecordSet combine(boolean all, List<ColumnMetadata> columns, RecordSet lRecordSet, RecordSet rRecordSet) {
        int[] lMappingIndexes = this.getColumnsMapping(columns, lRecordSet.getRecordSetDefinition().getColumns());
        RecordTranslator lTranslator = new RecordTranslator(lMappingIndexes);
        int[] rMappingIndexes = this.getColumnsMapping(columns, rRecordSet.getRecordSetDefinition().getColumns());
        RecordTranslator rTranslator = new RecordTranslator(rMappingIndexes);
        RecordComparator comparator = new RecordComparator(lMappingIndexes, rMappingIndexes);
        ArrayList<Object[]> result = new ArrayList<Object[]>(lRecordSet.getRecordsCount() + rRecordSet.getRecordsCount());
        if (!all) {
            this.distinct(lRecordSet.getRecords(), result, lTranslator);
            for (Object[] record : rRecordSet.getRecords()) {
                if (this.existRecord(record, result, comparator)) continue;
                result.add(rTranslator.translate(record));
            }
        } else {
            for (Object[] record : lRecordSet.getRecords()) {
                result.add(lTranslator.translate(record));
            }
            for (Object[] record : rRecordSet.getRecords()) {
                result.add(rTranslator.translate(record));
            }
        }
        RecordSetDefinition recordSetDefinition = this.createRecordSetDefinition();
        return new RecordSetImpl(recordSetDefinition, this.getStart(lRecordSet.getStart(), rRecordSet.getStart()), this.getEnd(lRecordSet.getEnd(), rRecordSet.getEnd()), result);
    }

    protected void distinct(List<Object[]> records, List<Object[]> result, RecordTranslator translator) {
        for (Object[] record : records) {
            boolean add = true;
            record = translator.translate(record);
            for (Object[] r : result) {
                if (!this.equals(record, r)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            result.add(record);
        }
    }
}

