/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core.cache;

import org.datayoo.moql.core.WashoutExecutor;
import org.datayoo.moql.core.cache.FifoWashoutExecutor;
import org.datayoo.moql.core.cache.FiloWashoutExecutor;
import org.datayoo.moql.core.cache.LfuWashoutExecutor;
import org.datayoo.moql.core.cache.LruWashoutExecutor;
import org.datayoo.moql.metadata.WashoutStrategy;

public abstract class WashoutExecutorFactory {
    protected static WashoutExecutor fifo;
    protected static WashoutExecutor filo;
    protected static WashoutExecutor lfu;
    protected static WashoutExecutor lru;

    public static synchronized WashoutExecutor createWashoutExecutor(WashoutStrategy washoutStrategy) {
        if (washoutStrategy == WashoutStrategy.FILO) {
            if (filo == null) {
                filo = new FiloWashoutExecutor();
            }
            return fifo;
        }
        if (washoutStrategy == WashoutStrategy.LFU) {
            if (lfu == null) {
                lfu = new LfuWashoutExecutor();
            }
            return lfu;
        }
        if (washoutStrategy == WashoutStrategy.LRU) {
            if (lru == null) {
                lru = new LruWashoutExecutor();
            }
            return lru;
        }
        if (fifo == null) {
            fifo = new FifoWashoutExecutor();
        }
        return fifo;
    }
}

