/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.DataSetMap;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.EntityMapImpl;
import org.datayoo.moql.core.Queryable;
import org.datayoo.moql.core.Table;
import org.datayoo.moql.core.Tables;
import org.datayoo.moql.metadata.TablesMetadata;

public class SingleTableTables
implements Tables {
    protected TablesMetadata tablesMetadata;
    protected Table table;
    protected List<EntityMap> result;

    public SingleTableTables(TablesMetadata tablesMetadata, Table table) {
        Validate.notNull((Object)tablesMetadata, (String)"Parameter 'tablesMetadata' is null!", (Object[])new Object[0]);
        Validate.notNull((Object)table, (String)"Parameter 'table' is null!", (Object[])new Object[0]);
        this.tablesMetadata = tablesMetadata;
        this.table = table;
    }

    @Override
    public Queryable<? extends Object> getQueryable() {
        return this.table;
    }

    @Override
    public TablesMetadata getTablesMetadata() {
        return this.tablesMetadata;
    }

    @Override
    public void bind(DataSetMap dataSetMap) {
        this.table.bind(dataSetMap);
        this.result = new LinkedList<EntityMap>();
        String tableName = this.table.getTableMetadata().getName();
        Iterator it = this.table.iterator();
        while (it.hasNext()) {
            EntityMapImpl entityMap = new EntityMapImpl();
            entityMap.putEntity(tableName, it.next());
            this.result.add(entityMap);
        }
    }

    @Override
    public Iterator<EntityMap> iterator() {
        return this.result.iterator();
    }
}

