/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.ColumnDefinition;
import org.datayoo.moql.RecordNode;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.RecordSetDefinition;
import org.datayoo.moql.core.RecordNodeImpl;
import org.datayoo.moql.util.StringFormater;

public class RecordSetImpl
implements RecordSet {
    public static final String COLUMN_SEPARATOR = ",";
    protected RecordSetDefinition recordSetDefinition;
    protected Date start;
    protected Date end;
    protected List<Object[]> records;

    public RecordSetImpl(RecordSetDefinition recordSetDefinition, Date start, Date end, List<Object[]> records) {
        Validate.notNull((Object)recordSetDefinition, (String)"Parameter 'recordSetDefinition' is null!", (Object[])new Object[0]);
        Validate.notNull((Object)start, (String)"Parameter 'start' is null!", (Object[])new Object[0]);
        Validate.notNull((Object)end, (String)"Parameter 'end' is null!", (Object[])new Object[0]);
        Validate.notNull(records, (String)"Parameter 'records' is null!", (Object[])new Object[0]);
        this.recordSetDefinition = recordSetDefinition;
        this.start = start;
        this.end = end;
        this.records = records;
    }

    @Override
    public Date getEnd() {
        return this.end;
    }

    @Override
    public Map<String, Object> getRecordAsMap(int index) {
        Object[] record = this.records.get(index);
        return this.toMap(record);
    }

    @Override
    public List<Map<String, Object>> getRecordsAsMaps() {
        ArrayList<Map<String, Object>> recordMapList = new ArrayList<Map<String, Object>>(this.records.size());
        for (Object[] record : this.records) {
            recordMapList.add(this.toMap(record));
        }
        return recordMapList;
    }

    @Override
    public List<RecordNode> getRecordsAsNodes() {
        String[] columns = new String[this.recordSetDefinition.getGroupColumns().size()];
        int i = 0;
        for (ColumnDefinition cd : this.recordSetDefinition.getGroupColumns()) {
            columns[i++] = cd.getName();
        }
        return this.getRecordNodesByColumns(columns);
    }

    @Override
    public List<RecordNode> getRecordNodesByColumns(String[] columns) {
        int[][] columnIndexes = this.translateColumns2Indexes(columns);
        RecordNodeImpl root = new RecordNodeImpl();
        for (Object[] record : this.records) {
            this.buildRecordNode(root, columnIndexes, record);
        }
        return root.getChildren();
    }

    protected void buildRecordNode(RecordNodeImpl root, int[][] columnIndexes, Object[] record) {
        RecordNodeImpl node = root;
        for (int i = 0; i < columnIndexes.length; ++i) {
            RecordNodeImpl rn;
            Object[] columns = new Object[columnIndexes[i].length];
            for (int j = 0; j < columns.length; ++j) {
                columns[j] = record[columnIndexes[i][j]];
            }
            if (i != columnIndexes.length - 1) {
                rn = (RecordNodeImpl)this.findRecordNode(node.getChildren(), columns);
                if (rn == null) {
                    rn = new RecordNodeImpl(columns);
                    node.addChild(rn);
                }
                node = rn;
                continue;
            }
            rn = new RecordNodeImpl(columns);
            node.addChild(rn);
        }
    }

    protected RecordNode findRecordNode(List<RecordNode> nodes, Object[] columns) {
        for (RecordNode node : nodes) {
            if (!Objects.deepEquals(node.getColumns(), columns)) continue;
            return node;
        }
        return null;
    }

    protected int[][] translateColumns2Indexes(String[] columns) {
        int i;
        int[][] indexes = new int[columns.length + 1][];
        int[] remainColumns = new int[this.recordSetDefinition.getColumns().size()];
        int remainSize = remainColumns.length;
        for (i = 0; i < remainColumns.length; ++i) {
            remainColumns[i] = i;
        }
        for (i = 0; i < columns.length; ++i) {
            String[] tokens = columns[i].split(COLUMN_SEPARATOR);
            int[] tIndexes = new int[tokens.length];
            for (int j = 0; j < tokens.length; ++j) {
                tIndexes[j] = this.recordSetDefinition.getColumnIndex(tokens[j]);
                if (tIndexes[j] == -1) {
                    throw new IllegalArgumentException(StringFormater.format((String)"There is no column named '{}'!", (Object[])new Object[]{tokens[j]}));
                }
                if (remainColumns[tIndexes[j]] == -1) continue;
                remainColumns[tIndexes[j]] = -1;
                --remainSize;
            }
            indexes[i] = tIndexes;
        }
        int[] remainIndexes = new int[remainSize];
        int j = 0;
        for (int i2 = 0; i2 < remainColumns.length; ++i2) {
            if (remainColumns[i2] == -1) continue;
            remainIndexes[j++] = remainColumns[i2];
        }
        indexes[columns.length] = remainIndexes;
        return indexes;
    }

    @Override
    public Object[] getRecord(int index) {
        return this.records.get(index);
    }

    @Override
    public List<Object> getColumn(String columnName) {
        int index = this.recordSetDefinition.getColumnIndex(columnName);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid column name!");
        }
        LinkedList<Object> data = new LinkedList<Object>();
        for (Object[] record : this.records) {
            data.add(record[index]);
        }
        return data;
    }

    @Override
    public RecordSetDefinition getRecordSetDefinition() {
        return this.recordSetDefinition;
    }

    @Override
    public List<Object[]> getRecords() {
        return this.records;
    }

    @Override
    public int getRecordsCount() {
        return this.records.size();
    }

    @Override
    public Date getStart() {
        return this.start;
    }

    @Override
    public Map<String, Object> toMap(Object[] record) {
        HashMap<String, Object> recordMap = new HashMap<String, Object>();
        int i = 0;
        for (ColumnDefinition column : this.recordSetDefinition.getColumns()) {
            recordMap.put(column.getName(), record[i++]);
        }
        return recordMap;
    }
}

