/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.ColumnDefinition;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.EntityMapImpl;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.Condition;
import org.datayoo.moql.core.Having;
import org.datayoo.moql.core.RecordSetImpl;
import org.datayoo.moql.metadata.ConditionMetadata;

public class HavingImpl
implements Having {
    protected Condition condition;

    public HavingImpl(Condition condition) {
        Validate.notNull((Object)condition, (String)"Parameter 'condition' is null!", (Object[])new Object[0]);
        this.condition = condition;
    }

    @Override
    public ConditionMetadata getHavingMetadata() {
        return this.condition.getConditionMetadata();
    }

    @Override
    public RecordSet decorate(RecordSet recordSet, Columns columns) {
        LinkedList<Object[]> resultRecords = new LinkedList<Object[]>();
        List<Object[]> records = recordSet.getRecords();
        for (Object[] record : records) {
            EntityMap entityMap = this.toEntityMap(recordSet, record);
            if (!this.condition.isMatch(entityMap)) continue;
            resultRecords.add(record);
        }
        return new RecordSetImpl(recordSet.getRecordSetDefinition(), recordSet.getStart(), recordSet.getEnd(), resultRecords);
    }

    protected EntityMap toEntityMap(RecordSet recordSet, Object[] record) {
        EntityMapImpl entityMap = new EntityMapImpl();
        int i = 0;
        for (ColumnDefinition column : recordSet.getRecordSetDefinition().getColumns()) {
            entityMap.putEntity(column.getName(), record[i++]);
        }
        return entityMap;
    }

    public Condition getCondition() {
        return this.condition;
    }
}

