/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.spark.transform.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.datavec.api.transform.analysis.DataAnalysis;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.split.RandomSplit;
import org.datavec.api.transform.split.SplitStrategy;
import org.datavec.api.transform.ui.HtmlAnalysis;
import org.datavec.api.writable.BooleanWritable;
import org.datavec.api.writable.ByteWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class SparkUtils {
    public static <T> List<JavaRDD<T>> splitData(SplitStrategy splitStrategy, JavaRDD<T> data, long seed) {
        if (splitStrategy instanceof RandomSplit) {
            RandomSplit rs = (RandomSplit)splitStrategy;
            double fractionTrain = rs.getFractionTrain();
            double[] splits = new double[]{fractionTrain, 1.0 - fractionTrain};
            JavaRDD[] split = data.randomSplit(splits, seed);
            ArrayList<JavaRDD<T>> list = new ArrayList<JavaRDD<T>>(2);
            Collections.addAll(list, split);
            return list;
        }
        throw new RuntimeException("Not yet implemented");
    }

    public static void writeStringToFile(String path, String toWrite, JavaSparkContext sc) throws IOException {
        SparkUtils.writeStringToFile(path, toWrite, sc.sc());
    }

    public static void writeStringToFile(String path, String toWrite, SparkContext sc) throws IOException {
        SparkUtils.writeStringToFile(path, toWrite, sc.hadoopConfiguration());
    }

    public static void writeStringToFile(String path, String toWrite, Configuration hadoopConfig) throws IOException {
        FileSystem fileSystem = FileSystem.get((Configuration)hadoopConfig);
        try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)fileSystem.create(new Path(path)));){
            bos.write(toWrite.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static String readStringFromFile(String path, JavaSparkContext sc) throws IOException {
        return SparkUtils.readStringFromFile(path, sc.sc());
    }

    public static String readStringFromFile(String path, SparkContext sc) throws IOException {
        return SparkUtils.readStringFromFile(path, sc.hadoopConfiguration());
    }

    public static String readStringFromFile(String path, Configuration hadoopConfig) throws IOException {
        FileSystem fileSystem = FileSystem.get((Configuration)hadoopConfig);
        try (BufferedInputStream bis = new BufferedInputStream((InputStream)fileSystem.open(new Path(path)));){
            byte[] asBytes = IOUtils.toByteArray((InputStream)bis);
            String string = new String(asBytes, StandardCharsets.UTF_8);
            return string;
        }
    }

    public static void writeObjectToFile(String path, Object toWrite, JavaSparkContext sc) throws IOException {
        SparkUtils.writeObjectToFile(path, toWrite, sc.sc());
    }

    public static void writeObjectToFile(String path, Object toWrite, SparkContext sc) throws IOException {
        SparkUtils.writeObjectToFile(path, toWrite, sc.hadoopConfiguration());
    }

    public static void writeObjectToFile(String path, Object toWrite, Configuration hadoopConfig) throws IOException {
        FileSystem fileSystem = FileSystem.get((Configuration)hadoopConfig);
        try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)fileSystem.create(new Path(path)));){
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(toWrite);
        }
    }

    public static <T> T readObjectFromFile(String path, Class<T> type, JavaSparkContext sc) throws IOException {
        return SparkUtils.readObjectFromFile(path, type, sc.sc());
    }

    public static <T> T readObjectFromFile(String path, Class<T> type, SparkContext sc) throws IOException {
        return SparkUtils.readObjectFromFile(path, type, sc.hadoopConfiguration());
    }

    public static <T> T readObjectFromFile(String path, Class<T> type, Configuration hadoopConfig) throws IOException {
        FileSystem fileSystem = FileSystem.get((Configuration)hadoopConfig);
        try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream((InputStream)fileSystem.open(new Path(path))));){
            Object o;
            try {
                o = ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            Object object = o;
            return (T)object;
        }
    }

    public static void writeSchema(String outputPath, Schema schema, JavaSparkContext sc) throws IOException {
        SparkUtils.writeStringToFile(outputPath, schema.toString(), sc);
    }

    public static void writeAnalysisHTMLToFile(String outputPath, DataAnalysis dataAnalysis, JavaSparkContext sc) {
        try {
            String analysisAsHtml = HtmlAnalysis.createHtmlAnalysisString((DataAnalysis)dataAnalysis);
            SparkUtils.writeStringToFile(outputPath, analysisAsHtml, sc);
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating or writing HTML analysis file (normalized data)", e);
        }
    }

    public static void writeWritablesToFile(String outputPath, String delim, List<List<Writable>> writables, JavaSparkContext sc) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (List<Writable> list : writables) {
            boolean first = true;
            for (Writable w : list) {
                if (!first) {
                    sb.append(delim);
                }
                sb.append(w.toString());
                first = false;
            }
            sb.append("\n");
        }
        SparkUtils.writeStringToFile(outputPath, sb.toString(), sc);
    }

    public static void registerKryoClasses(SparkConf conf) {
        List<Class> classes = Arrays.asList(BooleanWritable.class, ByteWritable.class, DoubleWritable.class, FloatWritable.class, IntWritable.class, LongWritable.class, NullWritable.class, Text.class);
        conf.registerKryoClasses((Class[])classes.toArray());
    }

    public static Class<? extends CompressionCodec> getCompressionCodeClass(String compressionCodecClass) {
        Class<?> tempClass;
        try {
            tempClass = Class.forName(compressionCodecClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Invalid class for compression codec: " + compressionCodecClass + " (not found)", e);
        }
        if (!CompressionCodec.class.isAssignableFrom(tempClass)) {
            throw new RuntimeException("Invalid class for compression codec: " + compressionCodecClass + " (not a CompressionCodec)");
        }
        return tempClass;
    }
}

