/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.local.transforms.join;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.join.Join;
import org.datavec.api.writable.Writable;
import org.datavec.local.transforms.functions.FlatMapFunctionAdapter;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.shade.guava.collect.Iterables;

public class ExecuteJoinFromCoGroupFlatMapFunctionAdapter
implements FlatMapFunctionAdapter<Pair<List<Writable>, Pair<List<List<Writable>>, List<List<Writable>>>>, List<Writable>> {
    private final Join join;

    public ExecuteJoinFromCoGroupFlatMapFunctionAdapter(Join join) {
        this.join = join;
    }

    @Override
    public List<List<Writable>> call(Pair<List<Writable>, Pair<List<List<Writable>>, List<List<Writable>>>> t2) throws Exception {
        Iterable leftList = (Iterable)((Pair)t2.getSecond()).getFirst();
        Iterable rightList = (Iterable)((Pair)t2.getSecond()).getSecond();
        ArrayList<List<Writable>> ret = new ArrayList<List<Writable>>();
        Join.JoinType jt = this.join.getJoinType();
        switch (jt) {
            case Inner: {
                for (List jvl : leftList) {
                    for (List jvr : rightList) {
                        List joined = this.join.joinExamples(jvl, jvr);
                        ret.add(joined);
                    }
                }
                break;
            }
            case LeftOuter: {
                for (List jvl : leftList) {
                    if (Iterables.size((Iterable)rightList) == 0) {
                        List joined = this.join.joinExamples(jvl, null);
                        ret.add(joined);
                        continue;
                    }
                    for (List jvr : rightList) {
                        List joined = this.join.joinExamples(jvl, jvr);
                        ret.add(joined);
                    }
                }
                break;
            }
            case RightOuter: {
                for (List jvr : rightList) {
                    if (Iterables.size((Iterable)leftList) == 0) {
                        List joined = this.join.joinExamples(null, jvr);
                        ret.add(joined);
                        continue;
                    }
                    for (List jvl : leftList) {
                        List joined = this.join.joinExamples(jvl, jvr);
                        ret.add(joined);
                    }
                }
                break;
            }
            case FullOuter: {
                if (Iterables.size((Iterable)leftList) == 0) {
                    for (List jvr : rightList) {
                        List joined = this.join.joinExamples(null, jvr);
                        ret.add(joined);
                    }
                } else if (Iterables.size((Iterable)rightList) == 0) {
                    for (List jvl : leftList) {
                        List joined = this.join.joinExamples(jvl, null);
                        ret.add(joined);
                    }
                } else {
                    for (List jvl : leftList) {
                        for (List jvr : rightList) {
                            List joined = this.join.joinExamples(jvl, jvr);
                            ret.add(joined);
                        }
                    }
                }
                break;
            }
        }
        return ret;
    }
}

