/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.local.transforms.join;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.function.Function;
import org.nd4j.linalg.primitives.Pair;

public class ExtractKeysFunction
implements Function<List<Writable>, Pair<List<Writable>, List<Writable>>> {
    private int[] columnIndexes;

    public Pair<List<Writable>, List<Writable>> apply(List<Writable> writables) {
        List<Object> keyValues;
        if (this.columnIndexes.length == 1) {
            keyValues = Collections.singletonList(writables.get(this.columnIndexes[0]));
        } else {
            keyValues = new ArrayList(this.columnIndexes.length);
            for (int i : this.columnIndexes) {
                keyValues.add(writables.get(i));
            }
        }
        return Pair.of(keyValues, writables);
    }

    public ExtractKeysFunction(int[] columnIndexes) {
        this.columnIndexes = columnIndexes;
    }
}

