/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.local.transforms.analysis.aggregate;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.analysis.AnalysisCounter;
import org.datavec.api.transform.analysis.counter.BytesAnalysisCounter;
import org.datavec.api.transform.analysis.counter.CategoricalAnalysisCounter;
import org.datavec.api.transform.analysis.counter.DoubleAnalysisCounter;
import org.datavec.api.transform.analysis.counter.IntegerAnalysisCounter;
import org.datavec.api.transform.analysis.counter.LongAnalysisCounter;
import org.datavec.api.transform.analysis.counter.NDArrayAnalysisCounter;
import org.datavec.api.transform.analysis.counter.StringAnalysisCounter;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.function.BiFunction;

public class AnalysisAddFunction
implements BiFunction<List<AnalysisCounter>, List<Writable>, List<AnalysisCounter>> {
    private Schema schema;

    public List<AnalysisCounter> apply(List<AnalysisCounter> analysisCounters, List<Writable> writables) {
        int size;
        if (analysisCounters == null) {
            analysisCounters = new ArrayList<AnalysisCounter>();
            List columnTypes = this.schema.getColumnTypes();
            block10: for (ColumnType ct : columnTypes) {
                switch (ct) {
                    case String: {
                        analysisCounters.add((AnalysisCounter)new StringAnalysisCounter());
                        continue block10;
                    }
                    case Integer: {
                        analysisCounters.add((AnalysisCounter)new IntegerAnalysisCounter());
                        continue block10;
                    }
                    case Long: {
                        analysisCounters.add((AnalysisCounter)new LongAnalysisCounter());
                        continue block10;
                    }
                    case Double: {
                        analysisCounters.add((AnalysisCounter)new DoubleAnalysisCounter());
                        continue block10;
                    }
                    case Categorical: {
                        analysisCounters.add((AnalysisCounter)new CategoricalAnalysisCounter());
                        continue block10;
                    }
                    case Time: {
                        analysisCounters.add((AnalysisCounter)new LongAnalysisCounter());
                        continue block10;
                    }
                    case Bytes: {
                        analysisCounters.add((AnalysisCounter)new BytesAnalysisCounter());
                        continue block10;
                    }
                    case NDArray: {
                        analysisCounters.add((AnalysisCounter)new NDArrayAnalysisCounter());
                        continue block10;
                    }
                }
                throw new IllegalArgumentException("Unknown column type: " + ct);
            }
        }
        if ((size = analysisCounters.size()) != writables.size()) {
            throw new IllegalStateException("Writables list and number of counters does not match (" + writables.size() + " vs " + size + ")");
        }
        for (int i = 0; i < size; ++i) {
            analysisCounters.get(i).add(writables.get(i));
        }
        return analysisCounters;
    }

    public AnalysisAddFunction(Schema schema) {
        this.schema = schema;
    }
}

