/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.local.transforms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.transform.analysis.AnalysisCounter;
import org.datavec.api.transform.analysis.DataAnalysis;
import org.datavec.api.transform.analysis.DataVecAnalysisUtils;
import org.datavec.api.transform.analysis.histogram.HistogramCounter;
import org.datavec.api.transform.analysis.quality.QualityAnalysisAddFunction;
import org.datavec.api.transform.analysis.quality.QualityAnalysisState;
import org.datavec.api.transform.quality.DataQualityAnalysis;
import org.datavec.api.transform.quality.columns.ColumnQuality;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.datavec.local.transforms.analysis.aggregate.AnalysisAddFunction;
import org.datavec.local.transforms.analysis.histogram.HistogramAddFunction;

public class AnalyzeLocal {
    private static final int DEFAULT_MAX_HISTOGRAM_BUCKETS = 30;

    public static DataAnalysis analyze(Schema schema, RecordReader rr) {
        return AnalyzeLocal.analyze(schema, rr, 30);
    }

    public static DataAnalysis analyze(Schema schema, RecordReader rr, int maxHistogramBuckets) {
        AnalysisAddFunction addFn = new AnalysisAddFunction(schema);
        List<AnalysisCounter> counters = null;
        while (rr.hasNext()) {
            counters = addFn.apply(counters, rr.next());
        }
        double[][] minsMaxes = new double[counters.size()][2];
        List columnTypes = schema.getColumnTypes();
        List list = DataVecAnalysisUtils.convertCounters(counters, (double[][])minsMaxes, (List)columnTypes);
        List<HistogramCounter> histogramCounters = null;
        HistogramAddFunction add = new HistogramAddFunction(maxHistogramBuckets, schema, minsMaxes);
        if (rr.resetSupported()) {
            rr.reset();
            while (rr.hasNext()) {
                histogramCounters = add.apply(histogramCounters, rr.next());
            }
            DataVecAnalysisUtils.mergeCounters((List)list, histogramCounters);
        }
        return new DataAnalysis(schema, list);
    }

    public static DataQualityAnalysis analyzeQualitySequence(Schema schema, SequenceRecordReader data) {
        int nColumns = schema.numColumns();
        List states = new ArrayList();
        QualityAnalysisAddFunction addFn = new QualityAnalysisAddFunction(schema);
        while (data.hasNext()) {
            List seq = data.sequenceRecord();
            for (List step : seq) {
                states = addFn.apply(states, step);
            }
        }
        ArrayList<ColumnQuality> list = new ArrayList<ColumnQuality>(nColumns);
        for (QualityAnalysisState qualityState : states) {
            list.add(qualityState.getColumnQuality());
        }
        return new DataQualityAnalysis(schema, list);
    }

    public static DataQualityAnalysis analyzeQuality(Schema schema, RecordReader data) {
        int nColumns = schema.numColumns();
        List states = null;
        QualityAnalysisAddFunction addFn = new QualityAnalysisAddFunction(schema);
        while (data.hasNext()) {
            states = addFn.apply(states, data.next());
        }
        ArrayList<ColumnQuality> list = new ArrayList<ColumnQuality>(nColumns);
        for (QualityAnalysisState qualityState : states) {
            list.add(qualityState.getColumnQuality());
        }
        return new DataQualityAnalysis(schema, list);
    }

    public static Set<Writable> getUnique(String columnName, Schema schema, RecordReader data) {
        int colIdx = schema.getIndexOfColumn(columnName);
        HashSet<Writable> unique = new HashSet<Writable>();
        while (data.hasNext()) {
            List next = data.next();
            unique.add((Writable)next.get(colIdx));
        }
        return unique;
    }

    public static Map<String, Set<Writable>> getUnique(List<String> columnNames, Schema schema, RecordReader data) {
        HashMap<String, Set<Writable>> m = new HashMap<String, Set<Writable>>();
        for (String s : columnNames) {
            m.put(s, new HashSet());
        }
        while (data.hasNext()) {
            List next = data.next();
            for (String s : columnNames) {
                int idx = schema.getIndexOfColumn(s);
                ((Set)m.get(s)).add(next.get(idx));
            }
        }
        return m;
    }

    public static Set<Writable> getUniqueSequence(String columnName, Schema schema, SequenceRecordReader sequenceData) {
        int colIdx = schema.getIndexOfColumn(columnName);
        HashSet<Writable> unique = new HashSet<Writable>();
        while (sequenceData.hasNext()) {
            List next = sequenceData.sequenceRecord();
            for (List step : next) {
                unique.add((Writable)step.get(colIdx));
            }
        }
        return unique;
    }

    public static Map<String, Set<Writable>> getUniqueSequence(List<String> columnNames, Schema schema, SequenceRecordReader sequenceData) {
        HashMap<String, Set<Writable>> m = new HashMap<String, Set<Writable>>();
        for (String s : columnNames) {
            m.put(s, new HashSet());
        }
        while (sequenceData.hasNext()) {
            List next = sequenceData.sequenceRecord();
            for (List step : next) {
                for (String s : columnNames) {
                    int idx = schema.getIndexOfColumn(s);
                    ((Set)m.get(s)).add(step.get(idx));
                }
            }
        }
        return m;
    }
}

