/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.local.transforms;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.datavec.api.transform.ColumnOp;
import org.datavec.api.transform.DataAction;
import org.datavec.api.transform.ReduceOp;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.TransformProcess;
import org.datavec.api.transform.condition.Condition;
import org.datavec.api.transform.condition.column.BooleanColumnCondition;
import org.datavec.api.transform.condition.column.CategoricalColumnCondition;
import org.datavec.api.transform.condition.column.ColumnCondition;
import org.datavec.api.transform.condition.column.DoubleColumnCondition;
import org.datavec.api.transform.condition.column.IntegerColumnCondition;
import org.datavec.api.transform.condition.column.LongColumnCondition;
import org.datavec.api.transform.condition.column.TimeColumnCondition;
import org.datavec.api.transform.filter.ConditionFilter;
import org.datavec.api.transform.rank.CalculateSortedRank;
import org.datavec.api.transform.reduce.Reducer;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.datavec.dataframe.api.BooleanColumn;
import org.datavec.dataframe.api.CategoryColumn;
import org.datavec.dataframe.api.DateColumn;
import org.datavec.dataframe.api.DoubleColumn;
import org.datavec.dataframe.api.FloatColumn;
import org.datavec.dataframe.api.IntColumn;
import org.datavec.dataframe.api.LongColumn;
import org.datavec.dataframe.api.ShortColumn;
import org.datavec.dataframe.api.Table;
import org.datavec.dataframe.columns.Column;
import org.datavec.dataframe.columns.ColumnReference;
import org.datavec.dataframe.filtering.BooleanIsTrue;
import org.datavec.dataframe.filtering.Filter;
import org.datavec.dataframe.filtering.FloatEqualTo;
import org.datavec.dataframe.filtering.FloatGreaterThan;
import org.datavec.dataframe.filtering.FloatGreaterThanOrEqualTo;
import org.datavec.dataframe.filtering.FloatLessThan;
import org.datavec.dataframe.filtering.FloatNotEqualTo;
import org.datavec.dataframe.filtering.IntEqualTo;
import org.datavec.dataframe.filtering.IntGreaterThan;
import org.datavec.dataframe.filtering.IntGreaterThanOrEqualTo;
import org.datavec.dataframe.filtering.IntLessThan;
import org.datavec.dataframe.filtering.IntLessThanOrEqualTo;
import org.datavec.dataframe.filtering.StringEqualTo;
import org.datavec.dataframe.filtering.StringInSet;
import org.datavec.dataframe.filtering.StringNotEqualTo;
import org.datavec.dataframe.filtering.StringNotInSet;
import org.datavec.dataframe.filtering.TimeEqualTo;
import org.datavec.dataframe.filtering.TimeNotEqualTo;
import org.datavec.dataframe.filtering.doubles.DoubleEqualTo;
import org.datavec.dataframe.filtering.doubles.DoubleGreaterThan;
import org.datavec.dataframe.filtering.doubles.DoubleGreaterThanOrEqualTo;
import org.datavec.dataframe.filtering.doubles.DoubleLessThan;
import org.datavec.dataframe.filtering.doubles.DoubleLessThanOrEqualTo;
import org.datavec.dataframe.filtering.doubles.DoubleNotEqualTo;
import org.datavec.dataframe.filtering.ints.IntNotEqualTo;
import org.datavec.dataframe.filtering.longs.LongEqualTo;
import org.datavec.dataframe.filtering.longs.LongGreaterThan;
import org.datavec.dataframe.filtering.longs.LongGreaterThanOrEqualTo;
import org.datavec.dataframe.filtering.longs.LongLessThan;
import org.datavec.dataframe.filtering.longs.LongLessThanOrEqualTo;
import org.datavec.dataframe.filtering.longs.LongNotEqualTo;
import org.datavec.dataframe.filtering.times.IsAfter;
import org.datavec.dataframe.filtering.times.IsBefore;
import org.datavec.dataframe.reducing.NumericReduceFunction;
import org.datavec.dataframe.reducing.NumericReduceUtils;
import org.datavec.dataframe.store.ColumnMetadata;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class TableRecords {
    public static List<List<Writable>> executeNonTimeSeries(List<List<Writable>> inputWritables, TransformProcess transformProcess) {
        Table table = TableRecords.fromRecordsAndSchema(inputWritables, transformProcess.getInitialSchema());
        Table ret = TableRecords.transformNonTimeSeries(table, transformProcess);
        return TableRecords.fromTable(ret);
    }

    public static Table transformNonTimeSeries(Table table, TransformProcess transformProcess) {
        List dataActions = transformProcess.getActionList();
        Table ret = table.fullCopy();
        for (DataAction dataAction : dataActions) {
            if (dataAction.getTransform() != null) {
                ret = TableRecords.transformTable(table, dataAction.getTransform());
                continue;
            }
            if (dataAction.getFilter() != null) {
                ret = TableRecords.filterTable(ret, dataAction.getFilter());
                continue;
            }
            if (dataAction.getCalculateSortedRank() != null) {
                ret = TableRecords.sortedRank(ret, dataAction.getCalculateSortedRank());
                continue;
            }
            if (dataAction.getConvertFromSequence() != null) {
                throw new UnsupportedOperationException("Tables don't have a time series sequence, please use the List<Writable> version of this function for input");
            }
            if (dataAction.getReducer() != null) {
                ret = TableRecords.reduce(ret, (Reducer)dataAction.getReducer());
                continue;
            }
            if (dataAction.getSequenceSplit() == null) continue;
            throw new UnsupportedOperationException("Tables don't have a time series sequence, please use the List<Writable> version of this function for input");
        }
        return ret;
    }

    private static NumericReduceFunction getFunction(ReduceOp reduceOp) {
        switch (reduceOp) {
            case Stdev: {
                return NumericReduceUtils.stdDev;
            }
            case Sum: {
                return NumericReduceUtils.sum;
            }
            case Max: {
                return NumericReduceUtils.max;
            }
            case Mean: {
                return NumericReduceUtils.mean;
            }
            case Min: {
                return NumericReduceUtils.min;
            }
            case Count: {
                return NumericReduceUtils.count;
            }
            case CountUnique: {
                throw new IllegalArgumentException("Illegal operation " + reduceOp);
            }
            case Range: {
                throw new IllegalArgumentException("Illegal operation " + reduceOp);
            }
            case TakeFirst: {
                throw new IllegalArgumentException("Illegal operation " + reduceOp);
            }
            case TakeLast: {
                throw new IllegalArgumentException("Illegal operation " + reduceOp);
            }
            case Prod: {
                return NumericReduceUtils.product;
            }
        }
        throw new IllegalStateException("Illegal operation for reduce");
    }

    public static Table reduce(Table reduce, Reducer reducer) {
        if (reducer.getConditionalReductions() != null) {
            for (Map.Entry pair : reducer.getConditionalReductions().entrySet()) {
                Condition conditionToFilter = ((Reducer.ConditionalReduction)pair.getValue()).getCondition();
                String inputColumnName = (String)pair.getKey();
                Schema output = reducer.transform(reducer.getInputSchema());
                Filter filter = TableRecords.mapFilterFromCondition(conditionToFilter, inputColumnName, output);
                reduce = TableRecords.runReduce(reduce.selectWhere(filter), (ReduceOp)((Reducer.ConditionalReduction)pair.getValue()).getReductions().get(0), inputColumnName);
            }
        } else {
            for (Map.Entry pair : reducer.getOpMap().entrySet()) {
                reduce = TableRecords.runReduce(reduce, (ReduceOp)((List)pair.getValue()).get(0), (String)pair.getKey());
            }
        }
        return reduce;
    }

    private static Table runReduce(Table reduce, ReduceOp reduceOp, String columnNameToReduce) {
        switch (reduceOp) {
            case Count: {
                return reduce.countBy(reduce.categoryColumn(columnNameToReduce));
            }
            case CountUnique: {
                throw new IllegalArgumentException("Illegal operation ");
            }
            case Range: {
                throw new IllegalArgumentException("Illegal operation ");
            }
            case TakeFirst: {
                return reduce.first(1);
            }
            case TakeLast: {
                return reduce.last(1);
            }
        }
        NumericReduceFunction reduceFunction = TableRecords.getFunction(reduceOp);
        String outputName = columnNameToReduce = "reduced_" + columnNameToReduce;
        switch (reduce.column(columnNameToReduce).type()) {
            case FLOAT: {
                double val = reduce.reduce(columnNameToReduce, reduceFunction);
                FloatColumn floatColumn = FloatColumn.create((String)columnNameToReduce, (FloatArrayList)new FloatArrayList(new float[]{(float)val}));
                return Table.create((String)outputName, (Column[])new Column[]{floatColumn});
            }
            case LONG_INT: {
                long longVal = (long)reduce.reduce(columnNameToReduce, reduceFunction);
                LongColumn longColumn = LongColumn.create((String)columnNameToReduce, (LongArrayList)new LongArrayList(new long[]{longVal}));
                return Table.create((String)outputName, (Column[])new Column[]{longColumn});
            }
            case INTEGER: {
                int intVal = (int)reduce.reduce(columnNameToReduce, reduceFunction);
                IntColumn intColumn = IntColumn.create((String)columnNameToReduce, (IntArrayList)new IntArrayList(new int[]{intVal}));
                return Table.create((String)outputName, (Column[])new Column[]{intColumn});
            }
            case DOUBLE: {
                double doubleVal = reduce.reduce(columnNameToReduce, reduceFunction);
                DoubleColumn doubleColumn = DoubleColumn.create((String)columnNameToReduce, (DoubleArrayList)new DoubleArrayList(new double[]{doubleVal}));
                return Table.create((String)outputName, (Column[])new Column[]{doubleColumn});
            }
        }
        throw new IllegalStateException("Illegal column type  " + reduceOp);
    }

    public static Table sortedRank(Table toRank, CalculateSortedRank rank) {
        Table clone = toRank.fullCopy();
        LongColumn longColumn = new LongColumn(rank.outputColumnName(), toRank.rowCount());
        for (int i = 0; i < toRank.rowCount(); ++i) {
            longColumn.add((long)i);
        }
        clone.addColumn(new Column[]{longColumn});
        if (rank.isAscending()) {
            Table sorted = clone.sortAscendingOn(rank.columnNames());
            Table newTable = Table.create((String)"sorted", (Column[])new Column[]{sorted.column(rank.outputColumnName())});
            return newTable;
        }
        Table sorted = clone.sortDescendingOn(rank.columnNames());
        Table newTable = Table.create((String)"sorted", (Column[])new Column[]{sorted.column(rank.outputColumnName())});
        return newTable;
    }

    public static Filter mapFilterFromCondition(Condition condition, String columnName, Schema output) {
        if (condition instanceof ColumnCondition) {
            ColumnCondition columnCondition = (ColumnCondition)condition;
            ColumnReference columnReference = new ColumnReference(columnName);
            switch (output.getType(output.getIndexOfColumn(columnCondition.outputColumnName()))) {
                case String: {
                    CategoricalColumnCondition categoricalColumnCondition = (CategoricalColumnCondition)columnCondition;
                    switch (categoricalColumnCondition.getOp()) {
                        case Equal: {
                            return new StringEqualTo(columnReference, categoricalColumnCondition.getValue());
                        }
                        case NotEqual: {
                            return new StringNotEqualTo(columnReference, categoricalColumnCondition.getValue());
                        }
                        case InSet: {
                            return new StringInSet(columnReference, (Collection)categoricalColumnCondition.getSet());
                        }
                        case NotInSet: {
                            return new StringNotInSet(columnReference, (Collection)categoricalColumnCondition.getSet());
                        }
                    }
                }
                case Long: {
                    LongColumnCondition longColumnCondition = (LongColumnCondition)columnCondition;
                    switch (longColumnCondition.getOp()) {
                        case Equal: {
                            return new LongEqualTo(columnReference, longColumnCondition.getValue().longValue());
                        }
                        case NotEqual: {
                            return new LongNotEqualTo(columnReference, longColumnCondition.getValue().longValue());
                        }
                        case GreaterThan: {
                            return new LongGreaterThan(columnReference, longColumnCondition.getValue().longValue());
                        }
                        case LessOrEqual: {
                            return new LongLessThanOrEqualTo(columnReference, longColumnCondition.getValue().longValue());
                        }
                        case GreaterOrEqual: {
                            return new LongGreaterThanOrEqualTo(columnReference, longColumnCondition.getValue().longValue());
                        }
                        case LessThan: {
                            return new LongLessThan(columnReference, longColumnCondition.getValue().longValue());
                        }
                    }
                    throw new IllegalStateException("Illegal operation ");
                }
                case Categorical: {
                    CategoricalColumnCondition categoricalColumnCondition2 = (CategoricalColumnCondition)columnCondition;
                    switch (categoricalColumnCondition2.getOp()) {
                        case Equal: {
                            return new StringEqualTo(columnReference, categoricalColumnCondition2.getValue());
                        }
                        case NotEqual: {
                            return new StringNotEqualTo(columnReference, categoricalColumnCondition2.getValue());
                        }
                        case InSet: {
                            return new StringInSet(columnReference, (Collection)categoricalColumnCondition2.getSet());
                        }
                        case NotInSet: {
                            return new StringNotInSet(columnReference, (Collection)categoricalColumnCondition2.getSet());
                        }
                    }
                }
                case Float: {
                    DoubleColumnCondition floatColumnCondition = (DoubleColumnCondition)columnCondition;
                    switch (floatColumnCondition.getOp()) {
                        case Equal: {
                            return new FloatEqualTo(columnReference, floatColumnCondition.getValue().floatValue());
                        }
                        case NotEqual: {
                            return new FloatNotEqualTo(columnReference, floatColumnCondition.getValue().floatValue());
                        }
                        case GreaterThan: {
                            return new FloatGreaterThan(columnReference, floatColumnCondition.getValue().floatValue());
                        }
                        case LessOrEqual: {
                            return new FloatGreaterThanOrEqualTo(columnReference, floatColumnCondition.getValue().floatValue());
                        }
                        case GreaterOrEqual: {
                            return new FloatGreaterThanOrEqualTo(columnReference, floatColumnCondition.getValue().floatValue());
                        }
                        case LessThan: {
                            return new FloatLessThan(columnReference, floatColumnCondition.getValue().floatValue());
                        }
                    }
                    throw new IllegalStateException("Illegal operation ");
                }
                case Time: {
                    TimeColumnCondition timeColumnCondition = (TimeColumnCondition)columnCondition;
                    switch (timeColumnCondition.getOp()) {
                        case Equal: {
                            return new TimeEqualTo(columnReference, LocalTime.ofNanoOfDay(timeColumnCondition.getValue()));
                        }
                        case NotEqual: {
                            return new TimeNotEqualTo(columnReference, LocalTime.ofNanoOfDay(timeColumnCondition.getValue()));
                        }
                        case GreaterThan: {
                            return new IsAfter(columnReference, LocalTime.ofNanoOfDay(timeColumnCondition.getValue()));
                        }
                        case LessThan: {
                            return new IsBefore(columnReference, LocalTime.ofNanoOfDay(timeColumnCondition.getValue()));
                        }
                    }
                    throw new IllegalStateException("Illegal operation ");
                }
                case Boolean: {
                    BooleanColumnCondition booleanColumnCondition = (BooleanColumnCondition)columnCondition;
                    return new BooleanIsTrue(columnReference);
                }
                case Double: {
                    DoubleColumnCondition doubleColumnCondition = (DoubleColumnCondition)columnCondition;
                    switch (doubleColumnCondition.getOp()) {
                        case Equal: {
                            return new DoubleEqualTo(columnReference, doubleColumnCondition.getValue().doubleValue());
                        }
                        case NotEqual: {
                            return new DoubleNotEqualTo(columnReference, doubleColumnCondition.getValue().doubleValue());
                        }
                        case GreaterThan: {
                            return new DoubleGreaterThan(columnReference, doubleColumnCondition.getValue().doubleValue());
                        }
                        case LessOrEqual: {
                            return new DoubleLessThanOrEqualTo(columnReference, doubleColumnCondition.getValue().doubleValue());
                        }
                        case GreaterOrEqual: {
                            return new DoubleGreaterThanOrEqualTo(columnReference, doubleColumnCondition.getValue().doubleValue());
                        }
                        case LessThan: {
                            return new DoubleLessThan(columnReference, doubleColumnCondition.getValue().doubleValue());
                        }
                    }
                    throw new IllegalStateException("Illegal operation ");
                }
                case Integer: {
                    IntegerColumnCondition integerColumnCondition = (IntegerColumnCondition)columnCondition;
                    switch (integerColumnCondition.getOp()) {
                        case Equal: {
                            return new IntEqualTo(columnReference, integerColumnCondition.getValue().intValue());
                        }
                        case NotEqual: {
                            return new IntNotEqualTo(columnReference, integerColumnCondition.getValue().intValue());
                        }
                        case GreaterThan: {
                            return new IntGreaterThan(columnReference, integerColumnCondition.getValue().intValue());
                        }
                        case LessOrEqual: {
                            return new IntLessThanOrEqualTo(columnReference, integerColumnCondition.getValue().intValue());
                        }
                        case GreaterOrEqual: {
                            return new IntGreaterThanOrEqualTo(columnReference, integerColumnCondition.getValue().intValue());
                        }
                        case LessThan: {
                            return new IntLessThan(columnReference, integerColumnCondition.getValue().intValue());
                        }
                    }
                    throw new IllegalStateException("Illegal operation ");
                }
            }
            throw new IllegalArgumentException("Illegal type");
        }
        return null;
    }

    public static Filter mapToFilter(org.datavec.api.transform.filter.Filter toMap) {
        ConditionFilter conditionFilter = (ConditionFilter)toMap;
        Condition condition = conditionFilter.getCondition();
        Schema output = toMap.transform(toMap.getInputSchema());
        return TableRecords.mapFilterFromCondition(condition, toMap.columnName(), output);
    }

    public static Table filterTable(Table toFilter, org.datavec.api.transform.filter.Filter filter) {
        Table ret = toFilter;
        IntArrayList indicesToRemove = new IntArrayList();
        for (String columnName : filter.columnNames()) {
            Column column = toFilter.column(columnName);
            for (int i = 0; i < ret.rowCount(); ++i) {
                Object curr = TableRecords.getEntry(column, i);
                if (!filter.removeExample(curr)) continue;
                indicesToRemove.add(i);
            }
        }
        ret = toFilter.drop(indicesToRemove);
        return ret;
    }

    public static Table transformTable(Table table, Transform transform) {
        if (!(transform instanceof ColumnOp)) {
            throw new IllegalArgumentException("Transform operation must be of type ColumnOp");
        }
        Schema outputSchema = transform.transform(transform.getInputSchema());
        Table ret = TableRecords.tableFromSchema(outputSchema);
        for (Column c : ret.columns()) {
            if (!table.columnNames().contains(c.name())) continue;
            c.append(table.column(c.name()));
        }
        String[] columnNames = transform.columnNames();
        String[] newColumnNames = transform.outputColumnNames();
        List inputColumns = table.columns(columnNames);
        List outputColumns = ret.columns(newColumnNames);
        if (columnNames.length > newColumnNames.length) {
            for (int r = 0; r < ret.rowCount(); ++r) {
                Object output = transform.map(TableRecords.determineInput(r, inputColumns.toArray(new Column[inputColumns.size()])));
                TableRecords.setEntry((Column)outputColumns.get(0), r, output);
            }
        } else if (columnNames.length < newColumnNames.length) {
            for (int r = 0; r < ret.rowCount(); ++r) {
                Object output = transform.map(TableRecords.determineInput(r, inputColumns.toArray(new Column[inputColumns.size()])));
                TableRecords.setEntryList(outputColumns.toArray(new Column[outputColumns.size()]), r, output);
            }
        } else {
            boolean sameTypesForOutput = transform.getInputSchema().sameTypes(transform.transform(transform.getInputSchema()));
            for (String columnName : columnNames) {
                int i;
                Column column = table.column(columnName);
                Column retColumn = ret.column(columnName);
                if (column instanceof FloatColumn) {
                    FloatColumn floatColumn = (FloatColumn)column;
                    FloatColumn retFloatColumn = (FloatColumn)retColumn;
                    if (sameTypesForOutput) {
                        for (i = 0; i < floatColumn.size(); ++i) {
                            retFloatColumn.set(i, ((Float)transform.map((Object)Float.valueOf(floatColumn.get(i)))).floatValue());
                        }
                        continue;
                    }
                    ret.removeColumn(ret.columnIndex(retColumn));
                    for (i = 0; i < floatColumn.size(); ++i) {
                        Object output = transform.map((Object)Float.valueOf(floatColumn.get(i)));
                        TableRecords.setEntry(retColumn, i, output);
                    }
                    continue;
                }
                if (column instanceof LongColumn) {
                    LongColumn longColumn = (LongColumn)column;
                    LongColumn retLongColumn = (LongColumn)retColumn;
                    if (sameTypesForOutput) {
                        for (i = 0; i < longColumn.size(); ++i) {
                            retLongColumn.set(i, ((Long)transform.map((Object)longColumn.get(i))).longValue());
                        }
                        continue;
                    }
                    ret.removeColumn(ret.columnIndex(retColumn));
                    continue;
                }
                if (column instanceof BooleanColumn) {
                    BooleanColumn booleanColumn = (BooleanColumn)column;
                    BooleanColumn retBooleanColumn = (BooleanColumn)retColumn;
                    if (sameTypesForOutput) {
                        for (i = 0; i < booleanColumn.size(); ++i) {
                            retBooleanColumn.set(i, ((Boolean)transform.map((Object)booleanColumn.get(i))).booleanValue());
                        }
                        continue;
                    }
                    ret.removeColumn(ret.columnIndex(retColumn));
                    continue;
                }
                if (column instanceof CategoryColumn) {
                    CategoryColumn categoryColumn = (CategoryColumn)column;
                    CategoryColumn retCategoryColumn = (CategoryColumn)retColumn;
                    if (sameTypesForOutput) {
                        for (i = 0; i < categoryColumn.size(); ++i) {
                            retCategoryColumn.set(i, (String)transform.map((Object)categoryColumn.get(i)));
                        }
                        continue;
                    }
                    ret.removeColumn(ret.columnIndex(retColumn));
                    continue;
                }
                if (column instanceof DateColumn) {
                    DateColumn dateColumn = (DateColumn)column;
                    DateColumn retDateColumn = (DateColumn)retColumn;
                    if (sameTypesForOutput) {
                        for (i = 0; i < dateColumn.size(); ++i) {
                            retDateColumn.set(i, ((Integer)transform.map((Object)dateColumn.get(i))).intValue());
                        }
                        continue;
                    }
                    ret.removeColumn(ret.columnIndex(retColumn));
                    continue;
                }
                if (column instanceof IntColumn) {
                    IntColumn intColumn = (IntColumn)column;
                    IntColumn retIntColumn = (IntColumn)retColumn;
                    if (newColumnNames.length == 1) {
                        for (i = 0; i < intColumn.size(); ++i) {
                            retIntColumn.set(i, ((Integer)transform.map((Object)intColumn.get(i))).intValue());
                        }
                        continue;
                    }
                    ret.removeColumn(ret.columnIndex(retColumn));
                    continue;
                }
                if (column instanceof ShortColumn) {
                    ShortColumn shortColumn = (ShortColumn)column;
                    ShortColumn retShortColumn = (ShortColumn)retColumn;
                    if (sameTypesForOutput) {
                        for (i = 0; i < shortColumn.size(); ++i) {
                            retShortColumn.set(i, ((Short)transform.map((Object)shortColumn.get(i))).shortValue());
                        }
                        continue;
                    }
                    ret.removeColumn(ret.columnIndex(retColumn));
                    continue;
                }
                throw new IllegalStateException("Illegal column type " + column.getClass());
            }
        }
        return ret;
    }

    public static Object determineInput(int row, Column ... inputColumns) {
        if (inputColumns.length > 1) {
            switch (inputColumns[0].columnMetadata().getType()) {
                case BOOLEAN: {
                    ArrayList<Boolean> ret = new ArrayList<Boolean>();
                    for (Column c : inputColumns) {
                        BooleanColumn b = (BooleanColumn)c;
                        ret.add(b.get(row));
                    }
                    return ret;
                }
                case FLOAT: {
                    ArrayList<Float> retFloat = new ArrayList<Float>();
                    for (Column c : inputColumns) {
                        FloatColumn floats = (FloatColumn)c;
                        retFloat.add(Float.valueOf(floats.get(row)));
                    }
                    return retFloat;
                }
                case INTEGER: {
                    ArrayList<Integer> integers = new ArrayList<Integer>();
                    for (Column c : inputColumns) {
                        IntColumn intColumn = (IntColumn)c;
                        integers.add(intColumn.get(row));
                    }
                    return integers;
                }
                case LONG_INT: {
                    ArrayList<Long> longs = new ArrayList<Long>();
                    for (Column c : inputColumns) {
                        LongColumn longColumn = (LongColumn)c;
                        longs.add(longColumn.get(row));
                    }
                    return longs;
                }
                case CATEGORY: {
                    ArrayList<String> strings = new ArrayList<String>();
                    for (Column c : inputColumns) {
                        CategoryColumn categoryColumn = (CategoryColumn)c;
                        strings.add(categoryColumn.get(row));
                    }
                    return strings;
                }
            }
            throw new IllegalStateException("Illegal column type " + inputColumns[0].columnMetadata().getType());
        }
        return TableRecords.getEntry(inputColumns[0], row);
    }

    public static void setEntryList(Column[] columns, int row, Object value) {
        for (Column column : columns) {
            if (column instanceof FloatColumn) {
                List floatValues = (List)value;
                for (Float f : floatValues) {
                    TableRecords.setEntry(column, row, f);
                }
                continue;
            }
            if (column instanceof LongColumn) {
                List longValues = (List)value;
                for (Long l : longValues) {
                    TableRecords.setEntry(column, row, l);
                }
                continue;
            }
            if (column instanceof BooleanColumn) {
                List booleanList = (List)value;
                for (Boolean b : booleanList) {
                    TableRecords.setEntry(column, row, b);
                }
                continue;
            }
            if (column instanceof CategoryColumn) {
                List stringList = (List)value;
                for (Object s : stringList) {
                    TableRecords.setEntry(column, row, s);
                }
                continue;
            }
            if (column instanceof DateColumn) {
                List integerListDate = (List)value;
                for (Integer i : integerListDate) {
                    TableRecords.setEntry(column, row, i);
                }
                continue;
            }
            if (column instanceof IntColumn) {
                List ints = (List)value;
                for (Integer i : ints) {
                    TableRecords.setEntry(column, row, i);
                }
                continue;
            }
            if (column instanceof ShortColumn) {
                List shortList = (List)value;
                for (Object s : shortList) {
                    TableRecords.setEntry(column, row, s);
                }
                continue;
            }
            throw new IllegalStateException("Illegal column type " + column.getClass());
        }
    }

    public static void setEntry(Column column, int row, Object value) {
        if (column instanceof FloatColumn) {
            FloatColumn floatColumn = (FloatColumn)column;
            floatColumn.set(row, ((Float)value).floatValue());
        } else if (column instanceof LongColumn) {
            LongColumn longColumn = (LongColumn)column;
            longColumn.set(row, ((Long)value).longValue());
        } else if (column instanceof BooleanColumn) {
            BooleanColumn booleanColumn = (BooleanColumn)column;
            booleanColumn.set(row, ((Boolean)value).booleanValue());
        } else if (column instanceof CategoryColumn) {
            CategoryColumn categoryColumn = (CategoryColumn)column;
            categoryColumn.set(row, value.toString());
        } else if (column instanceof DateColumn) {
            DateColumn dateColumn = (DateColumn)column;
            dateColumn.set(row, ((Integer)value).intValue());
        } else if (column instanceof IntColumn) {
            IntColumn intColumn = (IntColumn)column;
            intColumn.set(row, ((Integer)value).intValue());
        } else if (column instanceof ShortColumn) {
            ShortColumn shortColumn = (ShortColumn)column;
            shortColumn.set(row, ((Short)value).shortValue());
        } else {
            throw new IllegalStateException("Illegal column type " + column.getClass());
        }
    }

    public static Object getEntry(Column column, int row) {
        if (column instanceof FloatColumn) {
            FloatColumn floatColumn = (FloatColumn)column;
            return Float.valueOf(floatColumn.get(row));
        }
        if (column instanceof LongColumn) {
            LongColumn longColumn = (LongColumn)column;
            return longColumn.get(row);
        }
        if (column instanceof BooleanColumn) {
            BooleanColumn booleanColumn = (BooleanColumn)column;
            return booleanColumn.get(row);
        }
        if (column instanceof CategoryColumn) {
            CategoryColumn categoryColumn = (CategoryColumn)column;
            return categoryColumn.get(row);
        }
        if (column instanceof DateColumn) {
            DateColumn dateColumn = (DateColumn)column;
            return dateColumn.get(row);
        }
        if (column instanceof IntColumn) {
            IntColumn intColumn = (IntColumn)column;
            return intColumn.get(row);
        }
        if (column instanceof ShortColumn) {
            ShortColumn shortColumn = (ShortColumn)column;
            return shortColumn.get(row);
        }
        throw new IllegalStateException("Illegal column type " + column.getClass());
    }

    public static INDArray arrayFromTable(Table table) {
        INDArray arr = Nd4j.create((int)table.rowCount(), (int)table.columnCount());
        for (int i = 0; i < table.rowCount(); ++i) {
            for (int j = 0; j < table.columnCount(); ++j) {
                arr.putScalar(i, j, Double.valueOf(table.get(j, i)).doubleValue());
            }
        }
        return arr;
    }

    public static List<List<Writable>> fromTable(Table table) {
        ArrayList<List<Writable>> ret = new ArrayList<List<Writable>>();
        for (int i = 0; i < table.rowCount(); ++i) {
            ret.add(new ArrayList());
            for (int j = 0; j < table.columnCount(); ++j) {
                ((List)ret.get(i)).add(new DoubleWritable(Double.valueOf(table.get(j, i)).doubleValue()));
            }
        }
        return ret;
    }

    public static Table fromRecordsAndSchema(List<List<Writable>> writable, Schema schema) {
        Table table = Table.create((String)"table", (Column[])TableRecords.columnsForSchema(schema));
        for (int i = 0; i < writable.size(); ++i) {
            List<Writable> row = writable.get(i);
            if (row.size() == 1 && row.get(0) instanceof NDArrayWritable) {
                NDArrayWritable ndArrayWritable = (NDArrayWritable)row.get(0);
                INDArray arr = ndArrayWritable.get();
                if (arr.columns() != schema.numColumns()) {
                    throw new IllegalArgumentException("Found ndarray writable of illegal size " + arr.columns());
                }
                for (int j = 0; j < arr.length(); ++j) {
                    table.floatColumn(j).add(arr.getDouble(j));
                }
                continue;
            }
            if (row.size() == schema.numColumns()) {
                for (int j = 0; j < row.size(); ++j) {
                    table.floatColumn(j).add(row.get(j).toDouble());
                }
                continue;
            }
            throw new IllegalArgumentException("Illegal writable list of size " + row.size() + " at index " + i);
        }
        return table;
    }

    public static Table tableFromSchema(Schema schema) {
        return Table.create((String)"newTable", (Column[])TableRecords.columnsForSchema(schema));
    }

    public static Column[] columnsForSchema(Schema schema) {
        Column[] ret = new Column[schema.numColumns()];
        block9: for (int i = 0; i < schema.numColumns(); ++i) {
            switch (schema.getType(i)) {
                case Double: {
                    ret[i] = new FloatColumn(schema.getName(i));
                    continue block9;
                }
                case Float: {
                    ret[i] = new FloatColumn(schema.getName(i));
                    continue block9;
                }
                case Long: {
                    ret[i] = new LongColumn(schema.getName(i));
                    continue block9;
                }
                case Integer: {
                    ret[i] = new IntColumn(schema.getName(i));
                    continue block9;
                }
                case Categorical: {
                    ret[i] = new CategoryColumn(schema.getName(i), 4);
                    continue block9;
                }
                case Time: {
                    ret[i] = new DateColumn(new ColumnMetadata((Column)new LongColumn(schema.getName(i))));
                    continue block9;
                }
                case Boolean: {
                    ret[i] = new BooleanColumn(new ColumnMetadata((Column)new IntColumn(schema.getName(i))));
                }
            }
        }
        return ret;
    }
}

