/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.util.jdbc;

import java.math.BigDecimal;
import org.datavec.api.writable.BooleanWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class JdbcWritableConverter {
    public static Writable convert(Object columnValue, int columnType) {
        switch (columnType) {
            case 16: {
                return new BooleanWritable(((Boolean)columnValue).booleanValue());
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return new Text(columnValue.toString());
            }
            case 6: 
            case 7: {
                return new FloatWritable(((Float)columnValue).floatValue());
            }
            case 2: 
            case 3: {
                return new DoubleWritable(((BigDecimal)columnValue).doubleValue());
            }
            case 8: {
                return new DoubleWritable(((Double)columnValue).doubleValue());
            }
            case -6: 
            case 4: 
            case 5: {
                return new IntWritable(((Integer)columnValue).intValue());
            }
            case -7: {
                return new BooleanWritable(((Boolean)columnValue).booleanValue());
            }
            case -5: {
                return new LongWritable(((Long)columnValue).longValue());
            }
        }
        throw new IllegalArgumentException("Column type unknown");
    }

    private JdbcWritableConverter() {
    }
}

