/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.jdbc;

import com.zaxxer.hikari.util.DriverDataSource;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataJdbc;
import org.datavec.api.records.reader.BaseRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.util.jdbc.JdbcWritableConverter;
import org.datavec.api.util.jdbc.ResettableResultSetIterator;
import org.datavec.api.writable.Writable;

public class JDBCRecordReader
extends BaseRecordReader {
    private final String query;
    private Connection conn;
    private Statement statement;
    private ResettableResultSetIterator iter;
    private ResultSetMetaData meta;
    private Configuration configuration;
    private boolean trimStrings = false;
    private int resultSetType = 1004;
    private DataSource dataSource;
    private final String metadataQuery;
    private final int[] metadataIndices;
    public static final String TRIM_STRINGS = NAME_SPACE + ".trimStrings";
    public static final String JDBC_URL = NAME_SPACE + ".jdbcUrl";
    public static final String JDBC_DRIVER_CLASS_NAME = NAME_SPACE + ".jdbcDriverClassName";
    public static final String JDBC_USERNAME = NAME_SPACE + ".jdbcUsername";
    public static final String JDBC_PASSWORD = NAME_SPACE + ".jdbcPassword";
    public static final String JDBC_RESULTSET_TYPE = NAME_SPACE + ".resultSetType";

    public JDBCRecordReader(String query) {
        this.query = query;
        this.metadataQuery = null;
        this.metadataIndices = null;
    }

    public JDBCRecordReader(String query, DataSource dataSource) {
        this.query = query;
        this.dataSource = dataSource;
        this.metadataQuery = null;
        this.metadataIndices = null;
    }

    public JDBCRecordReader(String query, DataSource dataSource, String metadataQuery, int[] metadataIndices) {
        this.query = query;
        this.dataSource = dataSource;
        this.metadataQuery = metadataQuery;
        this.metadataIndices = metadataIndices;
    }

    public void initialize(InputSplit split) throws IOException, InterruptedException {
        if (this.dataSource == null) {
            throw new IllegalStateException("Cannot initialize : no datasource");
        }
        this.initializeJdbc();
    }

    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.setConf(conf);
        this.setTrimStrings(conf.getBoolean(TRIM_STRINGS, this.trimStrings));
        this.setResultSetType(conf.getInt(JDBC_RESULTSET_TYPE, this.resultSetType));
        String jdbcUrl = conf.get(JDBC_URL);
        String driverClassName = conf.get(JDBC_DRIVER_CLASS_NAME);
        if (jdbcUrl == null ^ driverClassName == null) {
            throw new IllegalArgumentException("Both jdbc url and driver class name must be provided in order to configure JDBCRecordReader's datasource");
        }
        if (jdbcUrl != null) {
            this.dataSource = new DriverDataSource(jdbcUrl, driverClassName, new Properties(), conf.get(JDBC_USERNAME), conf.get(JDBC_PASSWORD));
        }
        this.initializeJdbc();
    }

    private void initializeJdbc() {
        try {
            this.conn = this.dataSource.getConnection();
            this.statement = this.conn.createStatement(this.resultSetType, 1007);
            this.statement.closeOnCompletion();
            ResultSet rs = this.statement.executeQuery(this.query);
            this.meta = rs.getMetaData();
            this.iter = new ResettableResultSetIterator(rs);
        }
        catch (SQLException e) {
            this.closeJdbc();
            throw new RuntimeException("Could not connect to the database", e);
        }
    }

    public List<Writable> next() {
        Object[] next = this.iter.next();
        this.invokeListeners(next);
        return this.toWritable(next);
    }

    private List<Writable> toWritable(Object[] item) {
        ArrayList<Writable> ret = new ArrayList<Writable>();
        this.invokeListeners(item);
        for (int i = 0; i < item.length; ++i) {
            try {
                Object columnValue = item[i];
                if (this.trimStrings && columnValue instanceof String) {
                    columnValue = ((String)columnValue).trim();
                }
                Writable writable = JdbcWritableConverter.convert(columnValue, this.meta.getColumnType(i + 1));
                ret.add(writable);
                continue;
            }
            catch (SQLException e) {
                this.closeJdbc();
                throw new RuntimeException("Error reading database metadata");
            }
        }
        return ret;
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public List<String> getLabels() {
        throw new UnsupportedOperationException("JDBCRecordReader does not support getLabels yet");
    }

    public void reset() {
        this.iter.reset();
    }

    public boolean resetSupported() {
        return true;
    }

    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("JDBCRecordReader does not support reading from a DataInputStream");
    }

    public Record nextRecord() {
        URI location;
        Object[] next = this.iter.next();
        this.invokeListeners(next);
        try {
            location = new URI(this.conn.getMetaData().getURL());
        }
        catch (URISyntaxException | SQLException e) {
            throw new IllegalStateException("Could not get sql connection metadata", e);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.metadataIndices != null) {
            for (int index : this.metadataIndices) {
                params.add(next[index]);
            }
        }
        RecordMetaDataJdbc rmd = new RecordMetaDataJdbc(location, this.metadataQuery, params, ((Object)((Object)this)).getClass());
        return new org.datavec.api.records.impl.Record(this.toWritable(next), (RecordMetaData)rmd);
    }

    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadFromMetaData(Collections.singletonList(recordMetaData)).get(0);
    }

    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        ArrayList<Record> ret = new ArrayList<Record>();
        for (RecordMetaData rmd : recordMetaDatas) {
            if (!(rmd instanceof RecordMetaDataJdbc)) {
                throw new IllegalArgumentException("Invalid metadata; expected RecordMetaDataJdbc instance; got: " + rmd);
            }
            QueryRunner runner = new QueryRunner();
            String request = ((RecordMetaDataJdbc)rmd).getRequest();
            try {
                Object[] item = (Object[])runner.query(this.conn, request, (ResultSetHandler)new ArrayHandler(), ((RecordMetaDataJdbc)rmd).getParams().toArray());
                ret.add((Record)new org.datavec.api.records.impl.Record(this.toWritable(item), rmd));
            }
            catch (SQLException e) {
                throw new IllegalArgumentException("Could not execute statement \"" + request + "\"", e);
            }
        }
        return ret;
    }

    public void close() throws IOException {
        this.closeJdbc();
    }

    private void closeJdbc() {
        DbUtils.closeQuietly((Statement)this.statement);
        DbUtils.closeQuietly((Connection)this.conn);
    }

    public void setConf(Configuration conf) {
        this.configuration = conf;
    }

    public Configuration getConf() {
        return this.configuration;
    }

    public void setTrimStrings(boolean trimStrings) {
        this.trimStrings = trimStrings;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

