/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.poi.excel;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.writer.impl.FileRecordWriter;
import org.datavec.api.split.InputSplit;
import org.datavec.api.split.partition.PartitionMetaData;
import org.datavec.api.split.partition.Partitioner;
import org.datavec.api.writable.BooleanWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class ExcelRecordWriter
extends FileRecordWriter {
    public static final String WORKSHEET_NAME = "org.datavec.poi.excel.worksheet.name";
    public static final String FILE_TYPE = "org.datavec.poi.excel.type";
    public static final String DEFAULT_FILE_TYPE = "xlsx";
    public static final String DEFAULT_WORKSHEET_NAME = "datavec-worksheet";
    private String workBookName = "datavec-worksheet";
    private String fileTypeToUse = "xlsx";
    private Sheet sheet;
    private Workbook workbook;

    private void createRow(int rowNum, int numCols, List<Writable> value) {
        Row headerRow = this.sheet.createRow(rowNum);
        int col = 0;
        for (Writable writable : value) {
            Cell cell = headerRow.createCell(col++);
            this.setValueForCell(cell, writable);
        }
        for (int i = 0; i < numCols; ++i) {
            this.sheet.autoSizeColumn(i);
        }
    }

    private void setValueForCell(Cell cell, Writable value) {
        if (value instanceof DoubleWritable || value instanceof LongWritable || value instanceof FloatWritable || value instanceof IntWritable) {
            cell.setCellValue(value.toDouble());
        } else if (value instanceof BooleanWritable) {
            cell.setCellValue(((BooleanWritable)value).get());
        } else if (value instanceof Text) {
            cell.setCellValue(value.toString());
        }
    }

    public boolean supportsBatch() {
        return true;
    }

    public void initialize(InputSplit inputSplit, Partitioner partitioner) throws Exception {
        this.conf = new Configuration();
        this.partitioner = partitioner;
        partitioner.init(inputSplit);
        this.out = new DataOutputStream(partitioner.currentOutputStream());
        this.initPoi();
    }

    private void initPoi() {
        this.workbook = this.fileTypeToUse.equals(DEFAULT_FILE_TYPE) ? new XSSFWorkbook() : new HSSFWorkbook();
        this.sheet = this.workbook.createSheet(this.workBookName);
    }

    public void initialize(Configuration configuration, InputSplit split, Partitioner partitioner) throws Exception {
        this.workBookName = configuration.get(WORKSHEET_NAME, DEFAULT_WORKSHEET_NAME);
        this.fileTypeToUse = configuration.get(FILE_TYPE, DEFAULT_FILE_TYPE);
        this.conf = configuration;
        partitioner.init(split);
        this.out = new DataOutputStream(partitioner.currentOutputStream());
        this.initPoi();
    }

    public PartitionMetaData write(List<Writable> record) throws IOException {
        this.createRow(this.partitioner.numRecordsWritten(), record.size(), record);
        this.reinitIfNecessary();
        return PartitionMetaData.builder().numRecordsUpdated(1).build();
    }

    public PartitionMetaData writeBatch(List<List<Writable>> batch) throws IOException {
        int numSoFar = 0;
        for (List<Writable> record : batch) {
            this.createRow(this.partitioner.numRecordsWritten() + numSoFar, record.size(), record);
            this.reinitIfNecessary();
            ++numSoFar;
        }
        return PartitionMetaData.builder().numRecordsUpdated(batch.size()).build();
    }

    private void reinitIfNecessary() throws IOException {
        if (this.partitioner.needsNewPartition()) {
            this.workbook.write((OutputStream)this.out);
            this.out.flush();
            this.out.close();
            this.workbook.close();
            this.initPoi();
            this.out = new DataOutputStream(this.partitioner.openNewStream());
        }
    }

    public void close() {
        if (this.workbook != null) {
            try {
                if (this.out != null) {
                    this.workbook.write((OutputStream)this.out);
                    this.out.flush();
                    this.out.close();
                }
                this.workbook.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

