/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.mnist.draw;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.ops.transforms.Transforms;

public class DrawReconstruction {
    public JFrame frame;
    BufferedImage img = new BufferedImage(this.width, this.height, 1);
    private INDArray data;
    private int width = 28;
    private int height = 28;
    public String title = "TEST";
    private int heightOffset = 0;
    private int widthOffset = 0;

    public DrawReconstruction(INDArray data, int heightOffset, int widthOffset) {
        this.data = data;
        this.heightOffset = heightOffset;
        this.widthOffset = widthOffset;
    }

    public DrawReconstruction(INDArray data) {
        this.data = Transforms.round((INDArray)data);
    }

    public void readjustToData() {
        this.width = this.data.columns();
        this.height = this.data.rows();
        this.img = new BufferedImage(this.width, this.height, 1);
    }

    public void draw() {
        WritableRaster r = this.img.getRaster();
        int[] equiv = new int[(int)this.data.length()];
        INDArray dataLinear = this.data.linearView();
        for (int i = 0; i < equiv.length; ++i) {
            equiv[i] = Math.round(dataLinear.getInt(new int[]{i}));
        }
        r.setDataElements(0, 0, this.width, this.height, equiv);
        this.frame = new JFrame(this.title);
        this.frame.setVisible(true);
        this.start();
        this.frame.add(new JLabel(new ImageIcon(this.getImage())));
        this.frame.pack();
        this.frame.setDefaultCloseOperation(2);
    }

    public void close() {
        this.frame.dispose();
    }

    public Image getImage() {
        return this.img;
    }

    public void start() {
        int[] pixels = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
        boolean running = true;
        while (running) {
            BufferStrategy bs = this.frame.getBufferStrategy();
            if (bs == null) {
                this.frame.createBufferStrategy(4);
                return;
            }
            for (int i = 0; i < this.width * this.height; ++i) {
                pixels[i] = 0;
            }
            Graphics g = bs.getDrawGraphics();
            g.drawImage(this.img, this.heightOffset, this.widthOffset, this.width, this.height, null);
            g.dispose();
            bs.show();
        }
    }
}

