/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.recordreader.objdetect.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.datavec.image.recordreader.objdetect.ImageObject;
import org.datavec.image.recordreader.objdetect.ImageObjectLabelProvider;

public class VocLabelProvider
implements ImageObjectLabelProvider {
    private static final String OBJECT_START_TAG = "<object>";
    private static final String OBJECT_END_TAG = "</object>";
    private static final String NAME_TAG = "<name>";
    private static final String XMIN_TAG = "<xmin>";
    private static final String YMIN_TAG = "<ymin>";
    private static final String XMAX_TAG = "<xmax>";
    private static final String YMAX_TAG = "<ymax>";
    private String annotationsDir;

    public VocLabelProvider(@NonNull String baseDirectory) {
        if (baseDirectory == null) {
            throw new NullPointerException("baseDirectory");
        }
        this.annotationsDir = FilenameUtils.concat((String)baseDirectory, (String)"Annotations");
        if (!new File(this.annotationsDir).exists()) {
            throw new IllegalStateException("Annotations directory does not exist. Annotation files should be present at baseDirectory/Annotations/nnnnnn.xml. Expected location: " + this.annotationsDir);
        }
    }

    @Override
    public List<ImageObject> getImageObjectsForPath(String path) {
        String xmlContent;
        int idx = path.lastIndexOf(47);
        String filename = path.substring((idx = Math.max(idx, path.lastIndexOf(92))) + 1, path.length() - 4);
        String xmlPath = FilenameUtils.concat((String)this.annotationsDir, (String)(filename + ".xml"));
        File xmlFile = new File(xmlPath);
        if (!xmlFile.exists()) {
            throw new IllegalStateException("Could not find XML file for image " + path + "; expected at " + xmlPath);
        }
        try {
            xmlContent = FileUtils.readFileToString((File)xmlFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String[] lines = xmlContent.split("\n");
        ArrayList<ImageObject> out = new ArrayList<ImageObject>();
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].contains(OBJECT_START_TAG)) continue;
            String name = null;
            int xmin = Integer.MIN_VALUE;
            int ymin = Integer.MIN_VALUE;
            int xmax = Integer.MIN_VALUE;
            int ymax = Integer.MIN_VALUE;
            while (!lines[i].contains(OBJECT_END_TAG)) {
                if (name == null && lines[i].contains(NAME_TAG)) {
                    int idxStartName = lines[i].indexOf(62) + 1;
                    int idxEndName = lines[i].lastIndexOf(60);
                    name = lines[i].substring(idxStartName, idxEndName);
                    ++i;
                    continue;
                }
                if (xmin == Integer.MIN_VALUE && lines[i].contains(XMIN_TAG)) {
                    xmin = this.extractAndParse(lines[i]);
                    ++i;
                    continue;
                }
                if (ymin == Integer.MIN_VALUE && lines[i].contains(YMIN_TAG)) {
                    ymin = this.extractAndParse(lines[i]);
                    ++i;
                    continue;
                }
                if (xmax == Integer.MIN_VALUE && lines[i].contains(XMAX_TAG)) {
                    xmax = this.extractAndParse(lines[i]);
                    ++i;
                    continue;
                }
                if (ymax == Integer.MIN_VALUE && lines[i].contains(YMAX_TAG)) {
                    ymax = this.extractAndParse(lines[i]);
                    ++i;
                    continue;
                }
                ++i;
            }
            if (name == null) {
                throw new IllegalStateException("Invalid object format: no name tag found for object in file " + xmlPath);
            }
            if (xmin == Integer.MIN_VALUE || ymin == Integer.MIN_VALUE || xmax == Integer.MIN_VALUE || ymax == Integer.MIN_VALUE) {
                throw new IllegalStateException("Invalid object format: did not find all of xmin/ymin/xmax/ymax tags in " + xmlPath);
            }
            out.add(new ImageObject(xmin, ymin, xmax, ymax, name));
        }
        return out;
    }

    private int extractAndParse(String line) {
        int idxStartName = line.indexOf(62) + 1;
        int idxEndName = line.lastIndexOf(60);
        String substring = line.substring(idxStartName, idxEndName);
        return Integer.parseInt(substring);
    }

    @Override
    public List<ImageObject> getImageObjectsForPath(URI uri) {
        return this.getImageObjectsForPath(uri.toString());
    }
}

