/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResizeImageTransform
extends BaseImageTransform<opencv_core.Mat> {
    private int newHeight;
    private int newWidth;
    private int srch;
    private int srcw;

    public ResizeImageTransform(@JsonProperty(value="newWidth") int newWidth, @JsonProperty(value="newHeight") int newHeight) {
        this(null, newWidth, newHeight);
    }

    public ResizeImageTransform(Random random, int newWidth, int newHeight) {
        super(random);
        this.newWidth = newWidth;
        this.newHeight = newHeight;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        opencv_core.Mat result = new opencv_core.Mat();
        this.srch = mat.rows();
        this.srcw = mat.cols();
        opencv_imgproc.resize((opencv_core.Mat)mat, (opencv_core.Mat)result, (opencv_core.Size)new opencv_core.Size(this.newWidth, this.newHeight));
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        float[] transformed = new float[coordinates.length];
        for (int i = 0; i < coordinates.length; i += 2) {
            transformed[i] = (float)this.newWidth * coordinates[i] / (float)this.srcw;
            transformed[i + 1] = (float)this.newHeight * coordinates[i + 1] / (float)this.srch;
        }
        return transformed;
    }
}

