/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(value={"splitChannels", "converter"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EqualizeHistTransform
extends BaseImageTransform {
    private int conversionCode;
    private opencv_core.MatVector splitChannels = new opencv_core.MatVector();

    public EqualizeHistTransform() {
        this(new Random(1234L), 6);
    }

    public EqualizeHistTransform(int conversionCode) {
        this(null, conversionCode);
    }

    public EqualizeHistTransform(Random random, int conversionCode) {
        super(random);
        this.conversionCode = conversionCode;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        opencv_core.Mat result = new opencv_core.Mat();
        try {
            if (mat.channels() == 1) {
                opencv_imgproc.equalizeHist((opencv_core.Mat)mat, (opencv_core.Mat)result);
            } else {
                opencv_core.split((opencv_core.Mat)mat, (opencv_core.MatVector)this.splitChannels);
                opencv_imgproc.equalizeHist((opencv_core.Mat)this.splitChannels.get(0L), (opencv_core.Mat)this.splitChannels.get(0L));
                opencv_core.merge((opencv_core.MatVector)this.splitChannels, (opencv_core.Mat)result);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        return coordinates;
    }
}

