/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Random;
import org.datavec.api.io.filters.BalancedPathFilter;
import org.datavec.api.io.filters.PathFilter;
import org.datavec.api.io.labels.PathLabelGenerator;
import org.datavec.api.io.labels.PatternPathLabelGenerator;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.FileSplit;
import org.datavec.api.split.InputSplit;
import org.datavec.image.data.Image;
import org.datavec.image.loader.BaseImageLoader;
import org.datavec.image.recordreader.ImageRecordReader;
import org.datavec.image.transform.ImageTransform;
import org.eclipse.deeplearning4j.resources.DataSetResource;
import org.eclipse.deeplearning4j.resources.ResourceDataSets;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LFWLoader
extends BaseImageLoader
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(LFWLoader.class);
    public static final int NUM_IMAGES = 13233;
    public static final int NUM_LABELS = 5749;
    public static final int SUB_NUM_IMAGES = 1054;
    public static final int SUB_NUM_LABELS = 432;
    public static final int HEIGHT = 250;
    public static final int WIDTH = 250;
    public static final int CHANNELS = 3;
    public static final String DATA_URL = "http://vis-www.cs.umass.edu/lfw/lfw.tgz";
    public static final String LABEL_URL = "http://vis-www.cs.umass.edu/lfw/lfw-names.txt";
    public static final String SUBSET_URL = "http://vis-www.cs.umass.edu/lfw/lfw-a.tgz";
    protected static final String REGEX_PATTERN = ".[0-9]+";
    public static final PathLabelGenerator LABEL_PATTERN = new PatternPathLabelGenerator(".[0-9]+");
    public String dataFile = "lfw";
    public String labelFile = "lfw-names.txt";
    public String subsetFile = "lfw-a";
    private static DataSetResource lfwFull = ResourceDataSets.lfwFullData();
    private static DataSetResource lfwSub = ResourceDataSets.lfwSubData();
    private static DataSetResource lfwLabels = ResourceDataSets.lfwFullData();
    protected boolean useSubset = false;
    protected InputSplit[] inputSplit;

    public LFWLoader() {
        this(false);
    }

    public LFWLoader(boolean useSubset) {
        this(new long[]{250L, 250L, 3L}, null, useSubset);
    }

    public LFWLoader(int[] imgDim, boolean useSubset) {
        this(imgDim, (ImageTransform)null, useSubset);
    }

    public LFWLoader(long[] imgDim, boolean useSubset) {
        this(imgDim, null, useSubset);
    }

    public LFWLoader(int[] imgDim, ImageTransform imgTransform, boolean useSubset) {
        this.height = imgDim[0];
        this.width = imgDim[1];
        this.channels = imgDim[2];
        this.imageTransform = imgTransform;
        this.useSubset = useSubset;
    }

    public LFWLoader(long[] imgDim, ImageTransform imgTransform, boolean useSubset) {
        this.height = imgDim[0];
        this.width = imgDim[1];
        this.channels = imgDim[2];
        this.imageTransform = imgTransform;
        this.useSubset = useSubset;
    }

    public void load() {
        this.load(13233L, 13233L, 5749L, LABEL_PATTERN, 1.0, this.rng);
    }

    public void load(long batchSize, long numExamples, long numLabels, PathLabelGenerator labelGenerator, double splitTrainTest, Random rng) {
        if (!this.imageFilesExist()) {
            if (this.useSubset) {
                lfwSub.download(true, 3, 20000, 20000);
                lfwLabels.download(true, 3, 30000, 3000);
            } else {
                lfwFull.download(true, 3, 20000, 20000);
                lfwLabels.download(true, 3, 30000, 3000);
            }
        }
        File inputDir = this.useSubset ? lfwSub.localCacheDirectory() : lfwFull.localCacheDirectory();
        FileSplit fileSplit = new FileSplit(inputDir, ALLOWED_FORMATS, rng);
        BalancedPathFilter pathFilter = new BalancedPathFilter(rng, ALLOWED_FORMATS, labelGenerator, numExamples, numLabels, 0L, batchSize, null);
        this.inputSplit = fileSplit.sample((PathFilter)pathFilter, new double[]{(double)numExamples * splitTrainTest, (double)numExamples * (1.0 - splitTrainTest)});
    }

    public boolean imageFilesExist() {
        if (this.useSubset) {
            if (!lfwSub.existsLocally()) {
                return lfwSub.existsLocally();
            }
        } else {
            return lfwFull.existsLocally();
        }
        return true;
    }

    public RecordReader getRecordReader(long numExamples) {
        return this.getRecordReader(numExamples, numExamples, new long[]{this.height, this.width, this.channels}, this.useSubset ? 432L : 5749L, LABEL_PATTERN, true, 1.0, new Random(System.currentTimeMillis()));
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, long numLabels, Random rng) {
        return this.getRecordReader(numExamples, batchSize, new long[]{this.height, this.width, this.channels}, numLabels, LABEL_PATTERN, true, 1.0, rng);
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, boolean train, double splitTrainTest) {
        return this.getRecordReader(numExamples, batchSize, new long[]{this.height, this.width, this.channels}, this.useSubset ? 432L : 5749L, LABEL_PATTERN, train, splitTrainTest, new Random(System.currentTimeMillis()));
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, int[] imgDim, boolean train, double splitTrainTest, Random rng) {
        return this.getRecordReader(numExamples, batchSize, imgDim, this.useSubset ? 432L : 5749L, LABEL_PATTERN, train, splitTrainTest, rng);
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, long[] imgDim, boolean train, double splitTrainTest, Random rng) {
        return this.getRecordReader(numExamples, batchSize, imgDim, this.useSubset ? 432L : 5749L, LABEL_PATTERN, train, splitTrainTest, rng);
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, PathLabelGenerator labelGenerator, boolean train, double splitTrainTest, Random rng) {
        return this.getRecordReader(numExamples, batchSize, new long[]{this.height, this.width, this.channels}, this.useSubset ? 432L : 5749L, labelGenerator, train, splitTrainTest, rng);
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, int[] imgDim, PathLabelGenerator labelGenerator, boolean train, double splitTrainTest, Random rng) {
        return this.getRecordReader(numExamples, batchSize, imgDim, this.useSubset ? 432L : 5749L, labelGenerator, train, splitTrainTest, rng);
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, long[] imgDim, PathLabelGenerator labelGenerator, boolean train, double splitTrainTest, Random rng) {
        return this.getRecordReader(numExamples, batchSize, imgDim, this.useSubset ? 432L : 5749L, labelGenerator, train, splitTrainTest, rng);
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, int[] imgDim, long numLabels, PathLabelGenerator labelGenerator, boolean train, double splitTrainTest, Random rng) {
        this.load(batchSize, numExamples, numLabels, labelGenerator, splitTrainTest, rng);
        ImageRecordReader recordReader = new ImageRecordReader(imgDim[0], imgDim[1], imgDim[2], labelGenerator, this.imageTransform);
        try {
            InputSplit data = train ? this.inputSplit[0] : this.inputSplit[1];
            recordReader.initialize(data);
        }
        catch (IOException | InterruptedException e) {
            log.error("", (Throwable)e);
        }
        return recordReader;
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, long[] imgDim, long numLabels, PathLabelGenerator labelGenerator, boolean train, double splitTrainTest, Random rng) {
        this.load(batchSize, numExamples, numLabels, labelGenerator, splitTrainTest, rng);
        ImageRecordReader recordReader = new ImageRecordReader(imgDim[0], imgDim[1], imgDim[2], labelGenerator, this.imageTransform);
        try {
            InputSplit data = train ? this.inputSplit[0] : this.inputSplit[1];
            recordReader.initialize(data);
        }
        catch (IOException | InterruptedException e) {
            log.error("", (Throwable)e);
        }
        return recordReader;
    }

    @Override
    public INDArray asRowVector(File f) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asRowVector(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asMatrix(File f) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asMatrix(File f, boolean nchw) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asMatrix(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asMatrix(InputStream inputStream, boolean nchw) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Image asImageMatrix(File f) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Image asImageMatrix(File f, boolean nchw) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Image asImageMatrix(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Image asImageMatrix(InputStream inputStream, boolean nchw) throws IOException {
        throw new UnsupportedOperationException();
    }
}

