/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.arrow;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.SeekableReadChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.BinaryMetaData;
import org.datavec.api.transform.metadata.BooleanMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.metadata.FloatMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.conversion.TypeConversion;
import org.datavec.api.util.ndarray.RecordConverter;
import org.datavec.api.writable.BooleanWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.datavec.arrow.recordreader.ArrowWritableRecordBatch;
import org.datavec.arrow.recordreader.ArrowWritableRecordTimeSeriesBatch;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.exception.ND4JIllegalArgumentException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.serde.binary.BinarySerde;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowConverter {
    private static final Logger log = LoggerFactory.getLogger(ArrowConverter.class);

    public static INDArray toArray(ArrowWritableRecordTimeSeriesBatch arrowWritableRecordBatch) {
        return RecordConverter.toTensor((List)((Object)arrowWritableRecordBatch));
    }

    public static INDArray toArray(ArrowWritableRecordBatch arrowWritableRecordBatch) {
        List<FieldVector> columnVectors = arrowWritableRecordBatch.getList();
        org.datavec.api.transform.schema.Schema schema = arrowWritableRecordBatch.getSchema();
        block11: for (int i = 0; i < schema.numColumns(); ++i) {
            switch (schema.getType(i)) {
                case Integer: {
                    continue block11;
                }
                case Float: {
                    continue block11;
                }
                case Double: {
                    continue block11;
                }
                case Long: {
                    continue block11;
                }
                case NDArray: {
                    continue block11;
                }
                default: {
                    throw new ND4JIllegalArgumentException("Illegal data type found for column " + schema.getName(i) + " of type " + schema.getType(i));
                }
            }
        }
        int rows = arrowWritableRecordBatch.getList().get(0).getValueCount();
        if (schema.numColumns() == 1 && schema.getMetaData(0).getColumnType() == ColumnType.NDArray) {
            INDArray[] toConcat = new INDArray[rows];
            VarBinaryVector valueVectors = (VarBinaryVector)arrowWritableRecordBatch.getList().get(0);
            for (int i = 0; i < rows; ++i) {
                INDArray fromTensor;
                byte[] bytes = valueVectors.get(i);
                ByteBuffer direct = ByteBuffer.allocateDirect(bytes.length);
                direct.put(bytes);
                toConcat[i] = fromTensor = BinarySerde.toArray((ByteBuffer)direct);
            }
            return Nd4j.concat((int)0, (INDArray[])toConcat);
        }
        int cols = schema.numColumns();
        INDArray arr = Nd4j.create((int)rows, (int)cols);
        block13: for (int i = 0; i < cols; ++i) {
            INDArray put = ArrowConverter.convertArrowVector(columnVectors.get(i), schema.getType(i));
            switch (arr.data().dataType()) {
                case FLOAT: {
                    arr.putColumn(i, Nd4j.create((float[])put.data().asFloat()).reshape((long)rows, 1L));
                    continue block13;
                }
                case DOUBLE: {
                    arr.putColumn(i, Nd4j.create((double[])put.data().asDouble()).reshape((long)rows, 1L));
                }
            }
        }
        return arr;
    }

    public static INDArray convertArrowVector(FieldVector fieldVector, ColumnType type) {
        DataBuffer buffer = null;
        int cols = fieldVector.getValueCount();
        ByteBuffer direct = ByteBuffer.allocateDirect(fieldVector.getDataBuffer().capacity());
        direct.order(ByteOrder.nativeOrder());
        fieldVector.getDataBuffer().getBytes(0, direct);
        direct.rewind();
        switch (type) {
            case Integer: {
                buffer = Nd4j.createBuffer((ByteBuffer)direct, (DataBuffer.Type)DataBuffer.Type.INT, (int)cols, (long)0L);
                break;
            }
            case Float: {
                buffer = Nd4j.createBuffer((ByteBuffer)direct, (DataBuffer.Type)DataBuffer.Type.FLOAT, (int)cols);
                break;
            }
            case Double: {
                buffer = Nd4j.createBuffer((ByteBuffer)direct, (DataBuffer.Type)DataBuffer.Type.DOUBLE, (int)cols);
                break;
            }
            case Long: {
                buffer = Nd4j.createBuffer((ByteBuffer)direct, (DataBuffer.Type)DataBuffer.Type.LONG, (int)cols);
            }
        }
        return Nd4j.create((DataBuffer)buffer, (int[])new int[]{cols, 1});
    }

    public static List<FieldVector> convertToArrowVector(INDArray from, List<String> name, ColumnType type, BufferAllocator bufferAllocator) {
        ArrayList<FieldVector> ret = new ArrayList<FieldVector>();
        if (from.isVector()) {
            long cols = from.length();
            switch (type) {
                case Double: {
                    double[] fromData = from.isView() ? from.dup().data().asDouble() : from.data().asDouble();
                    ret.add((FieldVector)ArrowConverter.vectorFor(bufferAllocator, name.get(0), fromData));
                    break;
                }
                case Float: {
                    float[] fromDataFloat = from.isView() ? from.dup().data().asFloat() : from.data().asFloat();
                    ret.add((FieldVector)ArrowConverter.vectorFor(bufferAllocator, name.get(0), fromDataFloat));
                    break;
                }
                case Integer: {
                    int[] fromDataInt = from.isView() ? from.dup().data().asInt() : from.data().asInt();
                    ret.add((FieldVector)ArrowConverter.vectorFor(bufferAllocator, name.get(0), fromDataInt));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal type " + type);
                }
            }
        } else {
            long cols = from.size(1);
            int i = 0;
            while ((long)i < cols) {
                INDArray column = from.getColumn((long)i);
                switch (type) {
                    case Double: {
                        double[] fromData = column.isView() ? column.dup().data().asDouble() : from.data().asDouble();
                        ret.add((FieldVector)ArrowConverter.vectorFor(bufferAllocator, name.get(i), fromData));
                        break;
                    }
                    case Float: {
                        float[] fromDataFloat = column.isView() ? column.dup().data().asFloat() : from.data().asFloat();
                        ret.add((FieldVector)ArrowConverter.vectorFor(bufferAllocator, name.get(i), fromDataFloat));
                        break;
                    }
                    case Integer: {
                        int[] fromDataInt = column.isView() ? column.dup().data().asInt() : from.data().asInt();
                        ret.add((FieldVector)ArrowConverter.vectorFor(bufferAllocator, name.get(i), fromDataInt));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal type " + type);
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    public static void writeRecordBatchTo(List<List<Writable>> recordBatch, org.datavec.api.transform.schema.Schema inputSchema, OutputStream outputStream) {
        RootAllocator bufferAllocator = new RootAllocator(Long.MAX_VALUE);
        ArrowConverter.writeRecordBatchTo((BufferAllocator)bufferAllocator, recordBatch, inputSchema, outputStream);
    }

    public static void writeRecordBatchTo(BufferAllocator bufferAllocator, List<List<Writable>> recordBatch, org.datavec.api.transform.schema.Schema inputSchema, OutputStream outputStream) {
        if (!(recordBatch instanceof ArrowWritableRecordBatch)) {
            Schema convertedSchema = ArrowConverter.toArrowSchema(inputSchema);
            List<FieldVector> columns = ArrowConverter.toArrowColumns(bufferAllocator, inputSchema, recordBatch);
            try {
                VectorSchemaRoot root = new VectorSchemaRoot(convertedSchema, columns, recordBatch.size());
                ArrowFileWriter writer = new ArrowFileWriter(root, ArrowConverter.providerForVectors(columns, convertedSchema.getFields()), Channels.newChannel(outputStream));
                writer.start();
                writer.writeBatch();
                writer.end();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        Schema convertedSchema = ArrowConverter.toArrowSchema(inputSchema);
        List<FieldVector> pair = ArrowConverter.toArrowColumns(bufferAllocator, inputSchema, recordBatch);
        try {
            VectorSchemaRoot root = new VectorSchemaRoot(convertedSchema, pair, recordBatch.size());
            ArrowFileWriter writer = new ArrowFileWriter(root, ArrowConverter.providerForVectors(pair, convertedSchema.getFields()), Channels.newChannel(outputStream));
            writer.start();
            writer.writeBatch();
            writer.end();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static List<List<List<Writable>>> toArrowWritablesTimeSeries(List<FieldVector> fieldVectors, org.datavec.api.transform.schema.Schema schema, int timeSeriesLength) {
        ArrowWritableRecordTimeSeriesBatch arrowWritableRecordBatch = new ArrowWritableRecordTimeSeriesBatch(fieldVectors, schema, timeSeriesLength);
        return arrowWritableRecordBatch;
    }

    public static ArrowWritableRecordBatch toArrowWritables(List<FieldVector> fieldVectors, org.datavec.api.transform.schema.Schema schema) {
        ArrowWritableRecordBatch arrowWritableRecordBatch = new ArrowWritableRecordBatch(fieldVectors, schema);
        return arrowWritableRecordBatch;
    }

    public static List<Writable> toArrowWritablesSingle(List<FieldVector> fieldVectors, org.datavec.api.transform.schema.Schema schema) {
        return ArrowConverter.toArrowWritables(fieldVectors, schema).get(0);
    }

    public static Pair<org.datavec.api.transform.schema.Schema, ArrowWritableRecordBatch> readFromFile(FileInputStream input) throws IOException {
        RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
        org.datavec.api.transform.schema.Schema retSchema = null;
        ArrowWritableRecordBatch ret = null;
        SeekableReadChannel channel = new SeekableReadChannel((SeekableByteChannel)input.getChannel());
        ArrowFileReader reader = new ArrowFileReader(channel, (BufferAllocator)allocator);
        reader.loadNextBatch();
        retSchema = ArrowConverter.toDatavecSchema(reader.getVectorSchemaRoot().getSchema());
        VectorUnloader unloader = new VectorUnloader(reader.getVectorSchemaRoot());
        VectorLoader vectorLoader = new VectorLoader(reader.getVectorSchemaRoot());
        ArrowRecordBatch recordBatch = unloader.getRecordBatch();
        vectorLoader.load(recordBatch);
        ret = ArrowConverter.asDataVecBatch(recordBatch, retSchema, reader.getVectorSchemaRoot());
        ret.setUnloader(unloader);
        return Pair.of((Object)retSchema, (Object)ret);
    }

    public static Pair<org.datavec.api.transform.schema.Schema, ArrowWritableRecordBatch> readFromFile(File input) throws IOException {
        return ArrowConverter.readFromFile(new FileInputStream(input));
    }

    public static Pair<org.datavec.api.transform.schema.Schema, ArrowWritableRecordBatch> readFromBytes(byte[] input) throws IOException {
        RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
        org.datavec.api.transform.schema.Schema retSchema = null;
        ArrowWritableRecordBatch ret = null;
        SeekableReadChannel channel = new SeekableReadChannel((SeekableByteChannel)new ByteArrayReadableSeekableByteChannel(input));
        ArrowFileReader reader = new ArrowFileReader(channel, (BufferAllocator)allocator);
        reader.loadNextBatch();
        retSchema = ArrowConverter.toDatavecSchema(reader.getVectorSchemaRoot().getSchema());
        VectorUnloader unloader = new VectorUnloader(reader.getVectorSchemaRoot());
        VectorLoader vectorLoader = new VectorLoader(reader.getVectorSchemaRoot());
        ArrowRecordBatch recordBatch = unloader.getRecordBatch();
        vectorLoader.load(recordBatch);
        ret = ArrowConverter.asDataVecBatch(recordBatch, retSchema, reader.getVectorSchemaRoot());
        ret.setUnloader(unloader);
        return Pair.of((Object)retSchema, (Object)ret);
    }

    public static Schema toArrowSchema(org.datavec.api.transform.schema.Schema schema) {
        ArrayList<Field> fields = new ArrayList<Field>(schema.numColumns());
        for (int i = 0; i < schema.numColumns(); ++i) {
            fields.add(ArrowConverter.getFieldForColumn(schema.getName(i), schema.getType(i)));
        }
        return new Schema(fields);
    }

    public static org.datavec.api.transform.schema.Schema toDatavecSchema(Schema schema) {
        Schema.Builder schemaBuilder = new Schema.Builder();
        for (int i = 0; i < schema.getFields().size(); ++i) {
            schemaBuilder.addColumn(ArrowConverter.metaDataFromField((Field)schema.getFields().get(i)));
        }
        return schemaBuilder.build();
    }

    public static Field field(String name, ArrowType arrowType) {
        return new Field(name, FieldType.nullable((ArrowType)arrowType), new ArrayList());
    }

    public static Field getFieldForColumn(String name, ColumnType columnType) {
        switch (columnType) {
            case Long: {
                return ArrowConverter.field(name, (ArrowType)new ArrowType.Int(64, false));
            }
            case Integer: {
                return ArrowConverter.field(name, (ArrowType)new ArrowType.Int(32, false));
            }
            case Double: {
                return ArrowConverter.field(name, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE));
            }
            case Float: {
                return ArrowConverter.field(name, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE));
            }
            case Boolean: {
                return ArrowConverter.field(name, (ArrowType)new ArrowType.Bool());
            }
            case Categorical: {
                return ArrowConverter.field(name, (ArrowType)new ArrowType.Utf8());
            }
            case Time: {
                return ArrowConverter.field(name, (ArrowType)new ArrowType.Date(DateUnit.MILLISECOND));
            }
            case Bytes: {
                return ArrowConverter.field(name, (ArrowType)new ArrowType.Binary());
            }
            case NDArray: {
                return ArrowConverter.field(name, (ArrowType)new ArrowType.Binary());
            }
            case String: {
                return ArrowConverter.field(name, (ArrowType)new ArrowType.Utf8());
            }
        }
        throw new IllegalArgumentException("Column type invalid " + columnType);
    }

    public static Field doubleField(String name) {
        return ArrowConverter.getFieldForColumn(name, ColumnType.Double);
    }

    public static Field floatField(String name) {
        return ArrowConverter.getFieldForColumn(name, ColumnType.Float);
    }

    public static Field intField(String name) {
        return ArrowConverter.getFieldForColumn(name, ColumnType.Integer);
    }

    public static Field longField(String name) {
        return ArrowConverter.getFieldForColumn(name, ColumnType.Long);
    }

    public static Field stringField(String name) {
        return ArrowConverter.getFieldForColumn(name, ColumnType.String);
    }

    public static Field booleanField(String name) {
        return ArrowConverter.getFieldForColumn(name, ColumnType.Boolean);
    }

    public static DictionaryProvider providerForVectors(List<FieldVector> vectors, List<Field> fields) {
        Dictionary[] dictionaries = new Dictionary[vectors.size()];
        for (int i = 0; i < vectors.size(); ++i) {
            DictionaryEncoding dictionary = fields.get(i).getDictionary();
            if (dictionary == null) {
                dictionary = new DictionaryEncoding((long)i, true, null);
            }
            dictionaries[i] = new Dictionary(vectors.get(i), dictionary);
        }
        return new DictionaryProvider.MapDictionaryProvider(dictionaries);
    }

    public static List<FieldVector> toArrowColumns(BufferAllocator bufferAllocator, org.datavec.api.transform.schema.Schema schema, List<List<Writable>> dataVecRecord) {
        int numRows = dataVecRecord.size();
        List<FieldVector> ret = ArrowConverter.createFieldVectors(bufferAllocator, schema, numRows);
        for (int j = 0; j < schema.numColumns(); ++j) {
            FieldVector fieldVector = ret.get(j);
            int row = 0;
            for (List<Writable> record : dataVecRecord) {
                Writable writable = record.get(j);
                ArrowConverter.setValue(schema.getType(j), fieldVector, writable, row);
                ++row;
            }
        }
        return ret;
    }

    public static List<FieldVector> toArrowColumnsTimeSeries(BufferAllocator bufferAllocator, org.datavec.api.transform.schema.Schema schema, List<List<List<Writable>>> dataVecRecord) {
        return ArrowConverter.toArrowColumnsTimeSeriesHelper(bufferAllocator, schema, dataVecRecord);
    }

    public static <T> List<FieldVector> toArrowColumnsTimeSeriesHelper(BufferAllocator bufferAllocator, org.datavec.api.transform.schema.Schema schema, List<List<List<T>>> dataVecRecord) {
        int i;
        int numRows = 0;
        for (List<List<T>> timeStep : dataVecRecord) {
            numRows += timeStep.get(0).size() * timeStep.size();
        }
        List<FieldVector> ret = ArrowConverter.createFieldVectors(bufferAllocator, schema, numRows /= schema.numColumns());
        HashMap<Integer, Integer> currIndex = new HashMap<Integer, Integer>(ret.size());
        for (i = 0; i < ret.size(); ++i) {
            currIndex.put(i, 0);
        }
        for (i = 0; i < dataVecRecord.size(); ++i) {
            List<List<T>> record = dataVecRecord.get(i);
            for (int j = 0; j < record.size(); ++j) {
                List<T> curr = record.get(j);
                for (int k = 0; k < curr.size(); ++k) {
                    Integer idx = (Integer)currIndex.get(k);
                    FieldVector fieldVector = ret.get(k);
                    T writable = curr.get(k);
                    ArrowConverter.setValue(schema.getType(k), fieldVector, writable, idx);
                    currIndex.put(k, idx + 1);
                }
            }
        }
        return ret;
    }

    public static List<FieldVector> toArrowColumnsStringSingle(BufferAllocator bufferAllocator, org.datavec.api.transform.schema.Schema schema, List<String> dataVecRecord) {
        return ArrowConverter.toArrowColumnsString(bufferAllocator, schema, Arrays.asList(dataVecRecord));
    }

    public static List<FieldVector> toArrowColumnsStringTimeSeries(BufferAllocator bufferAllocator, org.datavec.api.transform.schema.Schema schema, List<List<List<String>>> dataVecRecord) {
        return ArrowConverter.toArrowColumnsTimeSeriesHelper(bufferAllocator, schema, dataVecRecord);
    }

    public static List<FieldVector> toArrowColumnsString(BufferAllocator bufferAllocator, org.datavec.api.transform.schema.Schema schema, List<List<String>> dataVecRecord) {
        int numRows = dataVecRecord.size();
        List<FieldVector> ret = ArrowConverter.createFieldVectors(bufferAllocator, schema, numRows);
        for (int j = 0; j < schema.numColumns(); ++j) {
            FieldVector fieldVector = ret.get(j);
            for (int row = 0; row < numRows; ++row) {
                String writable = dataVecRecord.get(row).get(j);
                ArrowConverter.setValue(schema.getType(j), fieldVector, writable, row);
            }
        }
        return ret;
    }

    private static List<FieldVector> createFieldVectors(BufferAllocator bufferAllocator, org.datavec.api.transform.schema.Schema schema, int numRows) {
        ArrayList<FieldVector> ret = new ArrayList<FieldVector>(schema.numColumns());
        block11: for (int i = 0; i < schema.numColumns(); ++i) {
            switch (schema.getType(i)) {
                case Integer: {
                    ret.add((FieldVector)ArrowConverter.intVectorOf(bufferAllocator, schema.getName(i), numRows));
                    continue block11;
                }
                case Long: {
                    ret.add((FieldVector)ArrowConverter.longVectorOf(bufferAllocator, schema.getName(i), numRows));
                    continue block11;
                }
                case Double: {
                    ret.add((FieldVector)ArrowConverter.doubleVectorOf(bufferAllocator, schema.getName(i), numRows));
                    continue block11;
                }
                case Float: {
                    ret.add((FieldVector)ArrowConverter.floatVectorOf(bufferAllocator, schema.getName(i), numRows));
                    continue block11;
                }
                case Boolean: {
                    ret.add((FieldVector)ArrowConverter.booleanVectorOf(bufferAllocator, schema.getName(i), numRows));
                    continue block11;
                }
                case String: {
                    ret.add((FieldVector)ArrowConverter.stringVectorOf(bufferAllocator, schema.getName(i), numRows));
                    continue block11;
                }
                case Categorical: {
                    ret.add((FieldVector)ArrowConverter.stringVectorOf(bufferAllocator, schema.getName(i), numRows));
                    continue block11;
                }
                case Time: {
                    ret.add((FieldVector)ArrowConverter.timeVectorOf(bufferAllocator, schema.getName(i), numRows));
                    continue block11;
                }
                case NDArray: {
                    ret.add((FieldVector)ArrowConverter.ndarrayVectorOf(bufferAllocator, schema.getName(i), numRows));
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Illegal type found for creation of field vectors" + schema.getType(i));
                }
            }
        }
        return ret;
    }

    public static void setValue(ColumnType columnType, FieldVector fieldVector, Object value, int row) {
        if (value instanceof NullWritable) {
            return;
        }
        try {
            switch (columnType) {
                case Integer: {
                    if (fieldVector instanceof IntVector) {
                        IntVector intVector = (IntVector)fieldVector;
                        int set = TypeConversion.getInstance().convertInt(value);
                        intVector.set(row, set);
                        break;
                    }
                    if (fieldVector instanceof UInt4Vector) {
                        UInt4Vector uInt4Vector = (UInt4Vector)fieldVector;
                        int set = TypeConversion.getInstance().convertInt(value);
                        uInt4Vector.set(row, set);
                        break;
                    }
                    throw new UnsupportedOperationException("Illegal type " + fieldVector.getClass() + " for int type");
                }
                case Float: {
                    Float4Vector float4Vector = (Float4Vector)fieldVector;
                    float set2 = TypeConversion.getInstance().convertFloat(value);
                    float4Vector.set(row, set2);
                    break;
                }
                case Double: {
                    double set3 = TypeConversion.getInstance().convertDouble(value);
                    Float8Vector float8Vector = (Float8Vector)fieldVector;
                    float8Vector.set(row, set3);
                    break;
                }
                case Long: {
                    if (fieldVector instanceof BigIntVector) {
                        BigIntVector largeIntVector = (BigIntVector)fieldVector;
                        largeIntVector.set(row, TypeConversion.getInstance().convertLong(value));
                        break;
                    }
                    if (fieldVector instanceof UInt8Vector) {
                        UInt8Vector uInt8Vector = (UInt8Vector)fieldVector;
                        uInt8Vector.set(row, TypeConversion.getInstance().convertLong(value));
                        break;
                    }
                    throw new UnsupportedOperationException("Illegal type " + fieldVector.getClass() + " for long type");
                }
                case Categorical: 
                case String: {
                    String stringSet = TypeConversion.getInstance().convertString(value);
                    VarCharVector textVector = (VarCharVector)fieldVector;
                    textVector.setSafe(row, stringSet.getBytes());
                    break;
                }
                case Time: {
                    long timeSet = TypeConversion.getInstance().convertLong(value);
                    ArrowConverter.setLongInTime(fieldVector, row, timeSet);
                    break;
                }
                case NDArray: {
                    NDArrayWritable arr = (NDArrayWritable)value;
                    VarBinaryVector nd4jArrayVector = (VarBinaryVector)fieldVector;
                    ByteBuffer byteBuffer = BinarySerde.toByteBuffer((INDArray)arr.get());
                    nd4jArrayVector.setSafe(row, byteBuffer, 0, byteBuffer.capacity());
                }
            }
        }
        catch (Exception e) {
            log.warn("Unable to set value at row " + row);
        }
    }

    private static void setLongInTime(FieldVector fieldVector, int index, long value) {
        if (fieldVector instanceof TimeStampMilliVector) {
            TimeStampMilliVector timeStampMilliVector = (TimeStampMilliVector)fieldVector;
            timeStampMilliVector.set(index, value);
        } else if (fieldVector instanceof TimeMilliVector) {
            TimeMilliVector timeMilliVector = (TimeMilliVector)fieldVector;
            timeMilliVector.set(index, (int)value);
        } else if (fieldVector instanceof TimeStampMicroVector) {
            TimeStampMicroVector timeStampMicroVector = (TimeStampMicroVector)fieldVector;
            timeStampMicroVector.set(index, value);
        } else if (fieldVector instanceof TimeSecVector) {
            TimeSecVector timeSecVector = (TimeSecVector)fieldVector;
            timeSecVector.set(index, (int)value);
        } else if (fieldVector instanceof TimeStampMilliVector) {
            TimeStampMilliVector timeStampMilliVector = (TimeStampMilliVector)fieldVector;
            timeStampMilliVector.set(index, value);
        } else if (fieldVector instanceof TimeStampMilliTZVector) {
            TimeStampMilliTZVector timeStampMilliTZVector = (TimeStampMilliTZVector)fieldVector;
            timeStampMilliTZVector.set(index, value);
        } else if (fieldVector instanceof TimeStampNanoTZVector) {
            TimeStampNanoTZVector timeStampNanoTZVector = (TimeStampNanoTZVector)fieldVector;
            timeStampNanoTZVector.set(index, value);
        } else if (fieldVector instanceof TimeStampMicroTZVector) {
            TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)fieldVector;
            timeStampMicroTZVector.set(index, value);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static TimeStampMilliVector vectorFor(BufferAllocator allocator, String name, Date[] data) {
        TimeStampMilliVector float4Vector = new TimeStampMilliVector(name, allocator);
        float4Vector.allocateNew(data.length);
        for (int i = 0; i < data.length; ++i) {
            float4Vector.setSafe(i, data[i].getTime());
        }
        float4Vector.setValueCount(data.length);
        return float4Vector;
    }

    public static TimeStampMilliVector timeVectorOf(BufferAllocator allocator, String name, int length) {
        TimeStampMilliVector float4Vector = new TimeStampMilliVector(name, allocator);
        float4Vector.allocateNew(length);
        float4Vector.setValueCount(length);
        return float4Vector;
    }

    public static VarBinaryVector vectorFor(BufferAllocator bufferAllocator, String name, INDArray[] data) {
        VarBinaryVector ret = new VarBinaryVector(name, bufferAllocator);
        ret.allocateNew();
        for (int i = 0; i < data.length; ++i) {
            ByteBuffer byteBuffer = BinarySerde.toByteBuffer((INDArray)data[i]);
            ret.set(i, byteBuffer, 0, byteBuffer.capacity());
        }
        return ret;
    }

    public static VarCharVector vectorFor(BufferAllocator allocator, String name, String[] data) {
        VarCharVector float4Vector = new VarCharVector(name, allocator);
        float4Vector.allocateNew();
        for (int i = 0; i < data.length; ++i) {
            float4Vector.setSafe(i, data[i].getBytes());
        }
        float4Vector.setValueCount(data.length);
        return float4Vector;
    }

    public static VarBinaryVector ndarrayVectorOf(BufferAllocator allocator, String name, int length) {
        VarBinaryVector ret = new VarBinaryVector(name, allocator);
        ret.allocateNewSafe();
        ret.setValueCount(length);
        return ret;
    }

    public static VarCharVector stringVectorOf(BufferAllocator allocator, String name, int length) {
        VarCharVector float4Vector = new VarCharVector(name, allocator);
        float4Vector.allocateNew();
        float4Vector.setValueCount(length);
        return float4Vector;
    }

    public static Float4Vector vectorFor(BufferAllocator allocator, String name, float[] data) {
        Float4Vector float4Vector = new Float4Vector(name, allocator);
        float4Vector.allocateNew(data.length);
        for (int i = 0; i < data.length; ++i) {
            float4Vector.setSafe(i, data[i]);
        }
        float4Vector.setValueCount(data.length);
        return float4Vector;
    }

    public static Float4Vector floatVectorOf(BufferAllocator allocator, String name, int length) {
        Float4Vector float4Vector = new Float4Vector(name, allocator);
        float4Vector.allocateNew(length);
        float4Vector.setValueCount(length);
        return float4Vector;
    }

    public static Float8Vector vectorFor(BufferAllocator allocator, String name, double[] data) {
        Float8Vector float8Vector = new Float8Vector(name, allocator);
        float8Vector.allocateNew(data.length);
        for (int i = 0; i < data.length; ++i) {
            float8Vector.setSafe(i, data[i]);
        }
        float8Vector.setValueCount(data.length);
        return float8Vector;
    }

    public static Float8Vector doubleVectorOf(BufferAllocator allocator, String name, int length) {
        Float8Vector float8Vector = new Float8Vector(name, allocator);
        float8Vector.allocateNew();
        float8Vector.setValueCount(length);
        return float8Vector;
    }

    public static BitVector vectorFor(BufferAllocator allocator, String name, boolean[] data) {
        BitVector float8Vector = new BitVector(name, allocator);
        float8Vector.allocateNew(data.length);
        for (int i = 0; i < data.length; ++i) {
            float8Vector.setSafe(i, data[i] ? 1 : 0);
        }
        float8Vector.setValueCount(data.length);
        return float8Vector;
    }

    public static BitVector booleanVectorOf(BufferAllocator allocator, String name, int length) {
        BitVector float8Vector = new BitVector(name, allocator);
        float8Vector.allocateNew(length);
        float8Vector.setValueCount(length);
        return float8Vector;
    }

    public static IntVector vectorFor(BufferAllocator allocator, String name, int[] data) {
        IntVector float8Vector = new IntVector(name, FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), allocator);
        float8Vector.allocateNew(data.length);
        for (int i = 0; i < data.length; ++i) {
            float8Vector.setSafe(i, data[i]);
        }
        float8Vector.setValueCount(data.length);
        return float8Vector;
    }

    public static IntVector intVectorOf(BufferAllocator allocator, String name, int length) {
        IntVector float8Vector = new IntVector(name, FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), allocator);
        float8Vector.allocateNew(length);
        float8Vector.setValueCount(length);
        return float8Vector;
    }

    public static BigIntVector vectorFor(BufferAllocator allocator, String name, long[] data) {
        BigIntVector float8Vector = new BigIntVector(name, FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), allocator);
        float8Vector.allocateNew(data.length);
        for (int i = 0; i < data.length; ++i) {
            float8Vector.setSafe(i, data[i]);
        }
        float8Vector.setValueCount(data.length);
        return float8Vector;
    }

    public static BigIntVector longVectorOf(BufferAllocator allocator, String name, int length) {
        BigIntVector float8Vector = new BigIntVector(name, FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), allocator);
        float8Vector.allocateNew(length);
        float8Vector.setValueCount(length);
        return float8Vector;
    }

    private static ColumnMetaData metaDataFromField(Field field) {
        ArrowType arrowType = field.getFieldType().getType();
        if (arrowType instanceof ArrowType.Int) {
            ArrowType.Int intType = (ArrowType.Int)arrowType;
            if (intType.getBitWidth() == 32) {
                return new IntegerMetaData(field.getName());
            }
            return new LongMetaData(field.getName());
        }
        if (arrowType instanceof ArrowType.Bool) {
            return new BooleanMetaData(field.getName());
        }
        if (arrowType instanceof ArrowType.FloatingPoint) {
            ArrowType.FloatingPoint floatingPointType = (ArrowType.FloatingPoint)arrowType;
            if (floatingPointType.getPrecision() == FloatingPointPrecision.DOUBLE) {
                return new DoubleMetaData(field.getName());
            }
            return new FloatMetaData(field.getName());
        }
        if (arrowType instanceof ArrowType.Binary) {
            return new BinaryMetaData(field.getName());
        }
        if (arrowType instanceof ArrowType.Utf8) {
            return new StringMetaData(field.getName());
        }
        if (arrowType instanceof ArrowType.Date) {
            return new TimeMetaData(field.getName());
        }
        throw new IllegalStateException("Illegal type " + field.getFieldType().getType());
    }

    public static Writable fromEntry(int item, FieldVector from, ColumnType columnType) {
        if (from.getValueCount() < item) {
            throw new IllegalArgumentException("Index specified greater than the number of items in the vector with length " + from.getValueCount());
        }
        switch (columnType) {
            case Integer: {
                return new IntWritable(ArrowConverter.getIntFromFieldVector(item, from));
            }
            case Long: {
                return new LongWritable(ArrowConverter.getLongFromFieldVector(item, from));
            }
            case Float: {
                return new FloatWritable(ArrowConverter.getFloatFromFieldVector(item, from));
            }
            case Double: {
                return new DoubleWritable(ArrowConverter.getDoubleFromFieldVector(item, from));
            }
            case Boolean: {
                BitVector bitVector = (BitVector)from;
                return new BooleanWritable(bitVector.get(item) > 0);
            }
            case Categorical: {
                VarCharVector varCharVector = (VarCharVector)from;
                return new Text(varCharVector.get(item));
            }
            case String: {
                VarCharVector varCharVector2 = (VarCharVector)from;
                return new Text(varCharVector2.get(item));
            }
            case Time: {
                return new LongWritable(ArrowConverter.getLongFromFieldVector(item, from));
            }
            case NDArray: {
                VarBinaryVector valueVector = (VarBinaryVector)from;
                byte[] bytes = valueVector.get(item);
                ByteBuffer direct = ByteBuffer.allocateDirect(bytes.length);
                direct.put(bytes);
                INDArray fromTensor = BinarySerde.toArray((ByteBuffer)direct);
                return new NDArrayWritable(fromTensor);
            }
        }
        throw new IllegalArgumentException("Illegal type " + from.getClass().getName());
    }

    private static int getIntFromFieldVector(int row, FieldVector fieldVector) {
        if (fieldVector instanceof UInt4Vector) {
            UInt4Vector uInt4Vector = (UInt4Vector)fieldVector;
            return uInt4Vector.get(row);
        }
        if (fieldVector instanceof IntVector) {
            IntVector intVector = (IntVector)fieldVector;
            return intVector.get(row);
        }
        throw new IllegalArgumentException("Illegal vector type for int " + fieldVector.getClass().getName());
    }

    private static long getLongFromFieldVector(int row, FieldVector fieldVector) {
        if (fieldVector instanceof UInt8Vector) {
            UInt8Vector uInt4Vector = (UInt8Vector)fieldVector;
            return uInt4Vector.get(row);
        }
        if (fieldVector instanceof IntVector) {
            BigIntVector intVector = (BigIntVector)fieldVector;
            return intVector.get(row);
        }
        if (fieldVector instanceof TimeStampMilliVector) {
            TimeStampMilliVector timeStampMilliVector = (TimeStampMilliVector)fieldVector;
            return timeStampMilliVector.get(row);
        }
        if (fieldVector instanceof BigIntVector) {
            BigIntVector bigIntVector = (BigIntVector)fieldVector;
            return bigIntVector.get(row);
        }
        if (fieldVector instanceof DateMilliVector) {
            DateMilliVector dateMilliVector = (DateMilliVector)fieldVector;
            return dateMilliVector.get(row);
        }
        if (fieldVector instanceof TimeStampMilliVector) {
            TimeStampMilliVector timeStampMilliVector = (TimeStampMilliVector)fieldVector;
            return timeStampMilliVector.get(row);
        }
        if (fieldVector instanceof TimeMilliVector) {
            TimeMilliVector timeMilliVector = (TimeMilliVector)fieldVector;
            return timeMilliVector.get(row);
        }
        if (fieldVector instanceof TimeStampMicroVector) {
            TimeStampMicroVector timeStampMicroVector = (TimeStampMicroVector)fieldVector;
            return timeStampMicroVector.get(row);
        }
        if (fieldVector instanceof TimeSecVector) {
            TimeSecVector timeSecVector = (TimeSecVector)fieldVector;
            return timeSecVector.get(row);
        }
        if (fieldVector instanceof TimeStampMilliVector) {
            TimeStampMilliVector timeStampMilliVector = (TimeStampMilliVector)fieldVector;
            return timeStampMilliVector.get(row);
        }
        if (fieldVector instanceof TimeStampMilliTZVector) {
            TimeStampMilliTZVector timeStampMilliTZVector = (TimeStampMilliTZVector)fieldVector;
            return timeStampMilliTZVector.get(row);
        }
        if (fieldVector instanceof TimeStampNanoTZVector) {
            TimeStampNanoTZVector timeStampNanoTZVector = (TimeStampNanoTZVector)fieldVector;
            return timeStampNanoTZVector.get(row);
        }
        if (fieldVector instanceof TimeStampMicroTZVector) {
            TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)fieldVector;
            return timeStampMicroTZVector.get(row);
        }
        throw new UnsupportedOperationException();
    }

    private static double getDoubleFromFieldVector(int row, FieldVector fieldVector) {
        if (fieldVector instanceof Float8Vector) {
            Float8Vector uInt4Vector = (Float8Vector)fieldVector;
            return uInt4Vector.get(row);
        }
        throw new IllegalArgumentException("Illegal vector type for int " + fieldVector.getClass().getName());
    }

    private static float getFloatFromFieldVector(int row, FieldVector fieldVector) {
        if (fieldVector instanceof Float4Vector) {
            Float4Vector uInt4Vector = (Float4Vector)fieldVector;
            return uInt4Vector.get(row);
        }
        throw new IllegalArgumentException("Illegal vector type for int " + fieldVector.getClass().getName());
    }

    private static ArrowWritableRecordBatch asDataVecBatch(ArrowRecordBatch arrowRecordBatch, org.datavec.api.transform.schema.Schema schema, VectorSchemaRoot vectorLoader) {
        ArrayList<FieldVector> fieldVectors = new ArrayList<FieldVector>();
        for (int j = 0; j < schema.numColumns(); ++j) {
            String name = schema.getName(j);
            FieldVector fieldVector = vectorLoader.getVector(name);
            fieldVectors.add(fieldVector);
        }
        ArrowWritableRecordBatch ret = new ArrowWritableRecordBatch(fieldVectors, schema);
        ret.setArrowRecordBatch(arrowRecordBatch);
        return ret;
    }
}

