/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.writable.comparator;

import java.util.Comparator;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.WritableType;
import org.datavec.api.writable.comparator.DoubleWritableComparator;
import org.datavec.api.writable.comparator.FloatWritableComparator;
import org.datavec.api.writable.comparator.IntWritableComparator;
import org.datavec.api.writable.comparator.LongWritableComparator;
import org.datavec.api.writable.comparator.ReverseComparator;
import org.datavec.api.writable.comparator.TextWritableComparator;
import org.datavec.api.writable.comparator.WritableComparator;

public class Comparators {
    private Comparators() {
    }

    public static Comparator<Writable> forType(WritableType type) {
        return Comparators.forType(type, true);
    }

    public static Comparator<Writable> forType(WritableType type, boolean ascending) {
        WritableComparator c;
        switch (type) {
            case Byte: 
            case Int: {
                c = new IntWritableComparator();
                break;
            }
            case Double: {
                c = new DoubleWritableComparator();
                break;
            }
            case Float: {
                c = new FloatWritableComparator();
                break;
            }
            case Long: {
                c = new LongWritableComparator();
                break;
            }
            case Text: {
                c = new TextWritableComparator();
                break;
            }
            default: {
                throw new UnsupportedOperationException("No built-in comparator for writable type: " + (Object)((Object)type));
            }
        }
        if (ascending) {
            return c;
        }
        return new ReverseComparator<Writable>(c);
    }
}

