/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence.trim;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.base.Preconditions;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"schema"})
public class SequenceTrimToLengthTransform
implements Transform {
    private int maxLength;
    private Mode mode;
    private List<Writable> pad;
    private Schema schema;

    public SequenceTrimToLengthTransform(@JsonProperty(value="maxLength") int maxLength, @JsonProperty(value="mode") Mode mode, @JsonProperty(value="pad") List<Writable> pad) {
        Preconditions.checkState((maxLength > 0 ? 1 : 0) != 0, (String)"Maximum length must be > 0, got %s", (int)maxLength);
        Preconditions.checkState((mode == Mode.TRIM || pad != null ? 1 : 0) != 0, (String)"If mode == Mode.TRIM_OR_PAD ");
        this.maxLength = maxLength;
        this.mode = mode;
        this.pad = pad;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        throw new UnsupportedOperationException("SequenceTrimToLengthTransform cannot be applied to non-sequence values");
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        if (this.mode == Mode.TRIM) {
            if (sequence.size() <= this.maxLength) {
                return sequence;
            }
            return new ArrayList<List<Writable>>(sequence.subList(0, this.maxLength));
        }
        if (sequence.size() == this.maxLength) {
            return sequence;
        }
        if (sequence.size() > this.maxLength) {
            return new ArrayList<List<Writable>>(sequence.subList(0, this.maxLength));
        }
        Preconditions.checkState((sequence.size() == 0 || sequence.get(0).size() == this.pad.size() ? 1 : 0) != 0, (String)"Invalid padding values: %s padding values were provided, but data has %s values per time step (columns)", (int)this.pad.size(), (int)sequence.get(0).size());
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>(this.maxLength);
        out.addAll(sequence);
        while (out.size() < this.maxLength) {
            out.add(this.pad);
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Schema transform(Schema inputSchema) {
        return inputSchema;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.schema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.schema;
    }

    @Override
    public String outputColumnName() {
        return null;
    }

    @Override
    public String[] outputColumnNames() {
        return this.schema.getColumnNames().toArray(new String[this.schema.numColumns()]);
    }

    @Override
    public String[] columnNames() {
        return this.outputColumnNames();
    }

    @Override
    public String columnName() {
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceTrimToLengthTransform)) {
            return false;
        }
        SequenceTrimToLengthTransform other = (SequenceTrimToLengthTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxLength() != other.getMaxLength()) {
            return false;
        }
        Mode this$mode = this.getMode();
        Mode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        List<Writable> this$pad = this.getPad();
        List<Writable> other$pad = other.getPad();
        return !(this$pad == null ? other$pad != null : !((Object)this$pad).equals(other$pad));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SequenceTrimToLengthTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxLength();
        Mode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        List<Writable> $pad = this.getPad();
        result = result * 59 + ($pad == null ? 43 : ((Object)$pad).hashCode());
        return result;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public Mode getMode() {
        return this.mode;
    }

    public List<Writable> getPad() {
        return this.pad;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setPad(List<Writable> pad) {
        this.pad = pad;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String toString() {
        return "SequenceTrimToLengthTransform(maxLength=" + this.getMaxLength() + ", mode=" + (Object)((Object)this.getMode()) + ", pad=" + this.getPad() + ", schema=" + this.getSchema() + ")";
    }

    public static enum Mode {
        TRIM,
        TRIM_OR_PAD;

    }
}

