/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.quality.time;

import org.datavec.api.transform.analysis.quality.QualityAnalysisState;
import org.datavec.api.transform.analysis.quality.time.TimeQualityAddFunction;
import org.datavec.api.transform.analysis.quality.time.TimeQualityMergeFunction;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.datavec.api.transform.quality.columns.ColumnQuality;
import org.datavec.api.transform.quality.columns.TimeQuality;
import org.datavec.api.writable.Writable;

public class TimeQualityAnalysisState
implements QualityAnalysisState<TimeQualityAnalysisState> {
    private TimeQuality timeQuality = new TimeQuality();
    private TimeQualityAddFunction addFunction;
    private TimeQualityMergeFunction mergeFunction;

    public TimeQualityAnalysisState(TimeMetaData timeMetaData) {
        this.addFunction = new TimeQualityAddFunction(timeMetaData);
        this.mergeFunction = new TimeQualityMergeFunction();
    }

    @Override
    public TimeQualityAnalysisState add(Writable writable) {
        this.timeQuality = this.addFunction.apply(this.timeQuality, writable);
        return this;
    }

    @Override
    public TimeQualityAnalysisState merge(TimeQualityAnalysisState other) {
        this.timeQuality = this.mergeFunction.apply(this.timeQuality, other.getTimeQuality());
        return this;
    }

    @Override
    public ColumnQuality getColumnQuality() {
        return this.timeQuality;
    }

    public TimeQuality getTimeQuality() {
        return this.timeQuality;
    }
}

