/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.filebatch;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.listener.RecordListener;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Writable;
import org.nd4j.api.loader.FileBatch;
import org.nd4j.base.Preconditions;

public class FileBatchRecordReader
implements RecordReader {
    private final RecordReader recordReader;
    private final FileBatch fileBatch;
    private int position = 0;

    public FileBatchRecordReader(RecordReader rr, FileBatch fileBatch) {
        this.recordReader = rr;
        this.fileBatch = fileBatch;
    }

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
    }

    @Override
    public boolean batchesSupported() {
        return false;
    }

    @Override
    public List<List<Writable>> next(int num) {
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>(Math.min(num, 10000));
        for (int i = 0; i < num && this.hasNext(); ++i) {
            out.add(this.next());
        }
        return out;
    }

    @Override
    public List<Writable> next() {
        List<Writable> out;
        Preconditions.checkState((boolean)this.hasNext(), (String)"No next element");
        byte[] fileBytes = (byte[])this.fileBatch.getFileBytes().get(this.position);
        String origPath = (String)this.fileBatch.getOriginalUris().get(this.position);
        try {
            out = this.recordReader.record(URI.create(origPath), new DataInputStream(new ByteArrayInputStream(fileBytes)));
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from file bytes");
        }
        ++this.position;
        return out;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.fileBatch.getFileBytes().size();
    }

    @Override
    public List<String> getLabels() {
        return this.recordReader.getLabels();
    }

    @Override
    public void reset() {
        this.position = 0;
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Record nextRecord() {
        return new org.datavec.api.records.impl.Record(this.next(), null);
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.recordReader.loadFromMetaData(recordMetaData);
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        return this.recordReader.loadFromMetaData(recordMetaDatas);
    }

    @Override
    public List<RecordListener> getListeners() {
        return null;
    }

    @Override
    public void setListeners(RecordListener ... listeners) {
        this.recordReader.setListeners(listeners);
    }

    @Override
    public void setListeners(Collection<RecordListener> listeners) {
        this.recordReader.setListeners(listeners);
    }

    @Override
    public void close() throws IOException {
        this.recordReader.close();
    }

    @Override
    public void setConf(Configuration conf) {
        this.recordReader.setConf(conf);
    }

    @Override
    public Configuration getConf() {
        return this.recordReader.getConf();
    }
}

