/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.writable;

import org.datavec.api.writable.ByteWritable;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.NullWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.api.ndarray.INDArray;

public class UnsafeWritableInjector {
    public static <T> Writable inject(T x) {
        if (x == null) {
            return NullWritable.INSTANCE;
        }
        if (x instanceof Writable) {
            return (Writable)x;
        }
        if (x instanceof INDArray) {
            throw new IllegalArgumentException("Wrong argument of type INDArray (" + x.getClass().getName() + ") please use org.datavec.common.data.NDArrayWritable manually to convert.");
        }
        if (x.getClass() == Integer.class) {
            return new IntWritable((Integer)x);
        }
        if (x.getClass() == Long.class) {
            return new LongWritable((Long)x);
        }
        if (x.getClass() == Float.class) {
            return new FloatWritable(((Float)x).floatValue());
        }
        if (x.getClass() == Double.class) {
            return new DoubleWritable((Double)x);
        }
        if (x instanceof String) {
            return new Text((String)x);
        }
        if (x instanceof Byte) {
            return new ByteWritable((Byte)x);
        }
        throw new IllegalArgumentException("Wrong argument type for writable conversion " + x.getClass().getName());
    }
}

