/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;

public class NaNColumnCondition
extends BaseColumnCondition {
    public NaNColumnCondition(String columnName) {
        this(columnName, DEFAULT_SEQUENCE_CONDITION_MODE);
    }

    public NaNColumnCondition(String columnName, SequenceConditionMode sequenceConditionMode) {
        super(columnName, sequenceConditionMode);
    }

    @Override
    public boolean columnCondition(Writable writable) {
        return Double.isNaN(writable.toDouble());
    }

    @Override
    public boolean condition(Object input) {
        return Double.isNaN(((Number)input).doubleValue());
    }

    @Override
    public String toString() {
        return "NaNColumnCondition()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NaNColumnCondition)) {
            return false;
        }
        NaNColumnCondition other = (NaNColumnCondition)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NaNColumnCondition;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

