/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.writable;

import com.google.common.math.DoubleMath;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.datavec.api.io.WritableComparable;
import org.datavec.api.io.WritableComparator;
import org.datavec.api.writable.ByteWritable;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;
import org.datavec.api.writable.WritableType;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class DoubleWritable
implements WritableComparable {
    private double value = 0.0;

    public DoubleWritable() {
    }

    public DoubleWritable(@JsonProperty(value="value") double value) {
        this.set(value);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readDouble();
    }

    @Override
    public void writeType(DataOutput out) throws IOException {
        out.writeShort(WritableType.Double.typeIdx());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.value);
    }

    public void set(double value) {
        this.value = value;
    }

    public double get() {
        return this.value;
    }

    public boolean fuzzyEquals(Writable o, double tolerance) {
        double other;
        if (o instanceof IntWritable) {
            other = ((IntWritable)o).toDouble();
        } else if (o instanceof LongWritable) {
            other = ((LongWritable)o).toDouble();
        } else if (o instanceof ByteWritable) {
            other = ((ByteWritable)o).toDouble();
        } else if (o instanceof DoubleWritable) {
            other = ((DoubleWritable)o).toDouble();
        } else if (o instanceof FloatWritable) {
            other = ((FloatWritable)o).toDouble();
        } else {
            return false;
        }
        return DoubleMath.fuzzyEquals((double)this.value, (double)other, (double)tolerance);
    }

    public boolean equals(Object o) {
        if (o instanceof DoubleWritable) {
            DoubleWritable other = (DoubleWritable)o;
            return this.value == other.value;
        }
        if (o instanceof FloatWritable) {
            FloatWritable other = (FloatWritable)o;
            float thisFloat = (float)this.value;
            return this.value == (double)thisFloat && other.get() == thisFloat;
        }
        return false;
    }

    public int hashCode() {
        long var2 = Double.doubleToLongBits(this.value);
        return (int)(var2 ^ var2 >>> 32);
    }

    @Override
    public int compareTo(Object o) {
        DoubleWritable other = (DoubleWritable)o;
        return this.value < other.value ? -1 : (this.value == other.value ? 0 : 1);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public float toFloat() {
        return (float)this.value;
    }

    @Override
    public int toInt() {
        return (int)this.value;
    }

    @Override
    public long toLong() {
        return (long)this.value;
    }

    @Override
    public WritableType getType() {
        return WritableType.Double;
    }

    static {
        WritableComparator.define(DoubleWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(DoubleWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            double thatValue;
            double thisValue = Comparator.readDouble(b1, s1);
            return thisValue < (thatValue = Comparator.readDouble(b2, s2)) ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

