/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.nlp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.sequence.expansion.BaseSequenceExpansionTransform;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"writableMap"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TextToTermIndexSequenceTransform
extends BaseSequenceExpansionTransform {
    private Map<String, Integer> wordIndexMap;
    private String delimiter;
    private boolean exceptionOnUnknown;
    private transient Map<String, List<Writable>> writableMap;

    public TextToTermIndexSequenceTransform(String columnName, String newColumnName, List<String> vocabulary, String delimiter, boolean exceptionOnUnknown) {
        super(Collections.singletonList(columnName), Collections.singletonList(newColumnName));
        this.wordIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < vocabulary.size(); ++i) {
            this.wordIndexMap.put(vocabulary.get(i), i);
        }
        this.delimiter = delimiter;
        this.exceptionOnUnknown = exceptionOnUnknown;
    }

    public TextToTermIndexSequenceTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="wordIndexMap") Map<String, Integer> wordIndexMap, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="exceptionOnUnknown") boolean exceptionOnUnknown) {
        super(Collections.singletonList(columnName), Collections.singletonList(newColumnName));
        this.wordIndexMap = wordIndexMap;
        this.delimiter = delimiter;
        this.exceptionOnUnknown = exceptionOnUnknown;
    }

    @Override
    protected List<ColumnMetaData> expandedColumnMetaDatas(List<ColumnMetaData> origColumnMeta, List<String> expandedColumnNames) {
        return Collections.singletonList(new IntegerMetaData(expandedColumnNames.get(0), 0, this.wordIndexMap.size() - 1));
    }

    @Override
    protected List<List<Writable>> expandTimeStep(List<Writable> currentStepValues) {
        String[] tokens;
        if (this.writableMap == null) {
            HashMap<String, List<Writable>> m = new HashMap<String, List<Writable>>();
            for (Map.Entry<String, Integer> entry : this.wordIndexMap.entrySet()) {
                m.put(entry.getKey(), Collections.singletonList(new IntWritable(entry.getValue())));
            }
            this.writableMap = m;
        }
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        String text = currentStepValues.get(0).toString();
        for (String token : tokens = text.split(this.delimiter)) {
            List<Writable> w = this.writableMap.get(token);
            if (w == null) {
                if (!this.exceptionOnUnknown) continue;
                throw new IllegalStateException("Unknown token found in text: \"" + token + "\"");
            }
            out.add(w);
        }
        return out;
    }

    public Map<String, Integer> getWordIndexMap() {
        return this.wordIndexMap;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public boolean isExceptionOnUnknown() {
        return this.exceptionOnUnknown;
    }

    public Map<String, List<Writable>> getWritableMap() {
        return this.writableMap;
    }

    public void setWordIndexMap(Map<String, Integer> wordIndexMap) {
        this.wordIndexMap = wordIndexMap;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setExceptionOnUnknown(boolean exceptionOnUnknown) {
        this.exceptionOnUnknown = exceptionOnUnknown;
    }

    public void setWritableMap(Map<String, List<Writable>> writableMap) {
        this.writableMap = writableMap;
    }

    public String toString() {
        return "TextToTermIndexSequenceTransform(wordIndexMap=" + this.getWordIndexMap() + ", delimiter=" + this.getDelimiter() + ", exceptionOnUnknown=" + this.isExceptionOnUnknown() + ", writableMap=" + this.getWritableMap() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextToTermIndexSequenceTransform)) {
            return false;
        }
        TextToTermIndexSequenceTransform other = (TextToTermIndexSequenceTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Integer> this$wordIndexMap = this.getWordIndexMap();
        Map<String, Integer> other$wordIndexMap = other.getWordIndexMap();
        if (this$wordIndexMap == null ? other$wordIndexMap != null : !((Object)this$wordIndexMap).equals(other$wordIndexMap)) {
            return false;
        }
        String this$delimiter = this.getDelimiter();
        String other$delimiter = other.getDelimiter();
        if (this$delimiter == null ? other$delimiter != null : !this$delimiter.equals(other$delimiter)) {
            return false;
        }
        return this.isExceptionOnUnknown() == other.isExceptionOnUnknown();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextToTermIndexSequenceTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Integer> $wordIndexMap = this.getWordIndexMap();
        result = result * 59 + ($wordIndexMap == null ? 43 : ((Object)$wordIndexMap).hashCode());
        String $delimiter = this.getDelimiter();
        result = result * 59 + ($delimiter == null ? 43 : $delimiter.hashCode());
        result = result * 59 + (this.isExceptionOnUnknown() ? 79 : 97);
        return result;
    }
}

