/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.metadata;

import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.BaseColumnMetaData;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class FloatMetaData
extends BaseColumnMetaData {
    private final Float minAllowedValue;
    private final Float maxAllowedValue;
    private final boolean allowNaN;
    private final boolean allowInfinite;

    public FloatMetaData(String name) {
        this(name, null, null, false, false);
    }

    public FloatMetaData(@JsonProperty(value="name") String name, @JsonProperty(value="minAllowedValue") Float minAllowedValue, @JsonProperty(value="maxAllowedValue") Float maxAllowedValue) {
        this(name, minAllowedValue, maxAllowedValue, false, false);
    }

    public FloatMetaData(String name, Float min, Float maxAllowedValue, boolean allowNaN, boolean allowInfinite) {
        super(name);
        this.minAllowedValue = min;
        this.maxAllowedValue = maxAllowedValue;
        this.allowNaN = allowNaN;
        this.allowInfinite = allowInfinite;
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.Float;
    }

    @Override
    public boolean isValid(Writable writable) {
        Float d;
        try {
            d = Float.valueOf(writable.toFloat());
        }
        catch (Exception e) {
            return false;
        }
        if (this.allowNaN && Float.isNaN(d.floatValue())) {
            return true;
        }
        if (this.allowInfinite && Float.isInfinite(d.floatValue())) {
            return true;
        }
        if (this.minAllowedValue != null && d.floatValue() < this.minAllowedValue.floatValue()) {
            return false;
        }
        return this.maxAllowedValue == null || !(d.floatValue() > this.maxAllowedValue.floatValue());
    }

    @Override
    public boolean isValid(Object input) {
        Float d;
        try {
            d = (Float)input;
        }
        catch (Exception e) {
            return false;
        }
        if (this.allowNaN && Float.isNaN(d.floatValue())) {
            return true;
        }
        if (this.allowInfinite && Float.isInfinite(d.floatValue())) {
            return true;
        }
        if (this.minAllowedValue != null && d.floatValue() < this.minAllowedValue.floatValue()) {
            return false;
        }
        return this.maxAllowedValue == null || !(d.floatValue() > this.maxAllowedValue.floatValue());
    }

    @Override
    public FloatMetaData clone() {
        return new FloatMetaData(this.name, this.minAllowedValue, this.maxAllowedValue, this.allowNaN, this.allowInfinite);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FloatMetaData(name=\"").append(this.name).append("\",");
        boolean needComma = false;
        if (this.minAllowedValue != null) {
            sb.append("minAllowed=").append(this.minAllowedValue);
            needComma = true;
        }
        if (this.maxAllowedValue != null) {
            if (needComma) {
                sb.append(",");
            }
            sb.append("maxAllowed=").append(this.maxAllowedValue);
            needComma = true;
        }
        if (needComma) {
            sb.append(",");
        }
        sb.append("allowNaN=").append(this.allowNaN).append(",allowInfinite=").append(this.allowInfinite).append(")");
        return sb.toString();
    }

    public Float getMinAllowedValue() {
        return this.minAllowedValue;
    }

    public Float getMaxAllowedValue() {
        return this.maxAllowedValue;
    }

    public boolean isAllowNaN() {
        return this.allowNaN;
    }

    public boolean isAllowInfinite() {
        return this.allowInfinite;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatMetaData)) {
            return false;
        }
        FloatMetaData other = (FloatMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$minAllowedValue = this.getMinAllowedValue();
        Float other$minAllowedValue = other.getMinAllowedValue();
        if (this$minAllowedValue == null ? other$minAllowedValue != null : !((Object)this$minAllowedValue).equals(other$minAllowedValue)) {
            return false;
        }
        Float this$maxAllowedValue = this.getMaxAllowedValue();
        Float other$maxAllowedValue = other.getMaxAllowedValue();
        if (this$maxAllowedValue == null ? other$maxAllowedValue != null : !((Object)this$maxAllowedValue).equals(other$maxAllowedValue)) {
            return false;
        }
        if (this.isAllowNaN() != other.isAllowNaN()) {
            return false;
        }
        return this.isAllowInfinite() == other.isAllowInfinite();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FloatMetaData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $minAllowedValue = this.getMinAllowedValue();
        result = result * 59 + ($minAllowedValue == null ? 43 : ((Object)$minAllowedValue).hashCode());
        Float $maxAllowedValue = this.getMaxAllowedValue();
        result = result * 59 + ($maxAllowedValue == null ? 43 : ((Object)$maxAllowedValue).hashCode());
        result = result * 59 + (this.isAllowNaN() ? 79 : 97);
        result = result * 59 + (this.isAllowInfinite() ? 79 : 97);
        return result;
    }
}

