/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.mapper;

import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.records.writer.RecordWriter;
import org.datavec.api.split.InputSplit;
import org.datavec.api.split.partition.Partitioner;
import org.datavec.api.writable.Writable;

public class RecordMapper {
    private RecordReader recordReader;
    private RecordWriter recordWriter;
    private InputSplit inputUrl;
    private InputSplit outputUrl;
    private Configuration configuration;
    private Partitioner partitioner;
    private int batchSize;

    public void copy() throws Exception {
        this.recordReader.initialize(this.configuration, this.inputUrl);
        this.partitioner.init(this.configuration, this.outputUrl);
        this.recordWriter.initialize(this.configuration, this.outputUrl, this.partitioner);
        if (this.batchSize > 0 && this.recordReader.batchesSupported() && this.recordWriter.supportsBatch()) {
            while (this.recordReader.hasNext()) {
                List<List<Writable>> next = this.recordReader.next(this.batchSize);
                if (this.partitioner.needsNewPartition()) {
                    this.partitioner.currentOutputStream().flush();
                    this.partitioner.currentOutputStream().close();
                    this.partitioner.openNewStream();
                }
                this.partitioner.updatePartitionInfo(this.recordWriter.writeBatch(next));
            }
            this.partitioner.currentOutputStream().flush();
            this.partitioner.currentOutputStream().close();
            this.recordReader.close();
            this.recordWriter.close();
        } else {
            while (this.recordReader.hasNext()) {
                List<Writable> next = this.recordReader.next();
                this.partitioner.updatePartitionInfo(this.recordWriter.write(next));
                if (!this.partitioner.needsNewPartition()) continue;
                this.partitioner.openNewStream();
            }
        }
    }

    private static Configuration $default$configuration() {
        return new Configuration();
    }

    RecordMapper(RecordReader recordReader, RecordWriter recordWriter, InputSplit inputUrl, InputSplit outputUrl, Configuration configuration, Partitioner partitioner, int batchSize) {
        this.recordReader = recordReader;
        this.recordWriter = recordWriter;
        this.inputUrl = inputUrl;
        this.outputUrl = outputUrl;
        this.configuration = configuration;
        this.partitioner = partitioner;
        this.batchSize = batchSize;
    }

    public static RecordMapperBuilder builder() {
        return new RecordMapperBuilder();
    }

    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    public static class RecordMapperBuilder {
        private RecordReader recordReader;
        private RecordWriter recordWriter;
        private InputSplit inputUrl;
        private InputSplit outputUrl;
        private boolean configuration$set;
        private Configuration configuration;
        private Partitioner partitioner;
        private int batchSize;

        RecordMapperBuilder() {
        }

        public RecordMapperBuilder recordReader(RecordReader recordReader) {
            this.recordReader = recordReader;
            return this;
        }

        public RecordMapperBuilder recordWriter(RecordWriter recordWriter) {
            this.recordWriter = recordWriter;
            return this;
        }

        public RecordMapperBuilder inputUrl(InputSplit inputUrl) {
            this.inputUrl = inputUrl;
            return this;
        }

        public RecordMapperBuilder outputUrl(InputSplit outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        public RecordMapperBuilder configuration(Configuration configuration) {
            this.configuration = configuration;
            this.configuration$set = true;
            return this;
        }

        public RecordMapperBuilder partitioner(Partitioner partitioner) {
            this.partitioner = partitioner;
            return this;
        }

        public RecordMapperBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public RecordMapper build() {
            Configuration configuration = this.configuration;
            if (!this.configuration$set) {
                configuration = RecordMapper.$default$configuration();
            }
            return new RecordMapper(this.recordReader, this.recordWriter, this.inputUrl, this.outputUrl, configuration, this.partitioner, this.batchSize);
        }

        public String toString() {
            return "RecordMapper.RecordMapperBuilder(recordReader=" + this.recordReader + ", recordWriter=" + this.recordWriter + ", inputUrl=" + this.inputUrl + ", outputUrl=" + this.outputUrl + ", configuration=" + this.configuration + ", partitioner=" + this.partitioner + ", batchSize=" + this.batchSize + ")";
        }
    }
}

