/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.column;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class AddConstantColumnTransform
implements Transform {
    private final String newColumnName;
    private final ColumnType newColumnType;
    private final Writable fixedValue;
    private Schema inputSchema;

    public AddConstantColumnTransform(@JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="newColumnType") ColumnType newColumnType, @JsonProperty(value="fixedValue") Writable fixedValue) {
        this.newColumnName = newColumnName;
        this.newColumnType = newColumnType;
        this.fixedValue = fixedValue;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        ArrayList<ColumnMetaData> outMeta = new ArrayList<ColumnMetaData>(inputSchema.getColumnMetaData());
        ColumnMetaData newColMeta = this.newColumnType.newColumnMetaData(this.newColumnName);
        outMeta.add(newColMeta);
        return inputSchema.newSchema(outMeta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public String outputColumnName() {
        return this.newColumnName;
    }

    @Override
    public String[] outputColumnNames() {
        return new String[]{this.outputColumnName()};
    }

    @Override
    public String[] columnNames() {
        return new String[0];
    }

    @Override
    public String columnName() {
        return this.newColumnName;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        ArrayList<Writable> out = new ArrayList<Writable>(writables.size() + 1);
        out.addAll(writables);
        out.add(this.fixedValue);
        return out;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        ArrayList<List<Writable>> outSeq = new ArrayList<List<Writable>>(sequence.size());
        for (List<Writable> l : sequence) {
            outSeq.add(this.map(l));
        }
        return outSeq;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException();
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public ColumnType getNewColumnType() {
        return this.newColumnType;
    }

    public Writable getFixedValue() {
        return this.fixedValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddConstantColumnTransform)) {
            return false;
        }
        AddConstantColumnTransform other = (AddConstantColumnTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$newColumnName = this.getNewColumnName();
        String other$newColumnName = other.getNewColumnName();
        if (this$newColumnName == null ? other$newColumnName != null : !this$newColumnName.equals(other$newColumnName)) {
            return false;
        }
        ColumnType this$newColumnType = this.getNewColumnType();
        ColumnType other$newColumnType = other.getNewColumnType();
        if (this$newColumnType == null ? other$newColumnType != null : !((Object)((Object)this$newColumnType)).equals((Object)other$newColumnType)) {
            return false;
        }
        Writable this$fixedValue = this.getFixedValue();
        Writable other$fixedValue = other.getFixedValue();
        if (this$fixedValue == null ? other$fixedValue != null : !this$fixedValue.equals(other$fixedValue)) {
            return false;
        }
        Schema this$inputSchema = this.getInputSchema();
        Schema other$inputSchema = other.getInputSchema();
        return !(this$inputSchema == null ? other$inputSchema != null : !((Object)this$inputSchema).equals(other$inputSchema));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddConstantColumnTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $newColumnName = this.getNewColumnName();
        result = result * 59 + ($newColumnName == null ? 43 : $newColumnName.hashCode());
        ColumnType $newColumnType = this.getNewColumnType();
        result = result * 59 + ($newColumnType == null ? 43 : ((Object)((Object)$newColumnType)).hashCode());
        Writable $fixedValue = this.getFixedValue();
        result = result * 59 + ($fixedValue == null ? 43 : $fixedValue.hashCode());
        Schema $inputSchema = this.getInputSchema();
        result = result * 59 + ($inputSchema == null ? 43 : ((Object)$inputSchema).hashCode());
        return result;
    }

    public String toString() {
        return "AddConstantColumnTransform(newColumnName=" + this.getNewColumnName() + ", newColumnType=" + (Object)((Object)this.getNewColumnType()) + ", fixedValue=" + this.getFixedValue() + ", inputSchema=" + this.getInputSchema() + ")";
    }
}

