/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ndarray;

import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.NDArrayMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class NDArrayScalarOpTransform
extends BaseColumnTransform {
    private final MathOp mathOp;
    private final double scalar;

    public NDArrayScalarOpTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="mathOp") MathOp mathOp, @JsonProperty(value="scalar") double scalar) {
        super(columnName);
        this.mathOp = mathOp;
        this.scalar = scalar;
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newName, ColumnMetaData oldColumnType) {
        if (!(oldColumnType instanceof NDArrayMetaData)) {
            throw new IllegalStateException("Column " + newName + " is not a NDArray column");
        }
        NDArrayMetaData oldMeta = (NDArrayMetaData)oldColumnType;
        NDArrayMetaData newMeta = oldMeta.clone();
        newMeta.setName(newName);
        return newMeta;
    }

    @Override
    public NDArrayWritable map(Writable w) {
        if (!(w instanceof NDArrayWritable)) {
            throw new IllegalArgumentException("Input writable is not an NDArrayWritable: is " + w.getClass());
        }
        NDArrayWritable n = (NDArrayWritable)w;
        INDArray a = n.get().dup();
        switch (this.mathOp) {
            case Add: {
                a.addi((Number)this.scalar);
                break;
            }
            case Subtract: {
                a.subi((Number)this.scalar);
                break;
            }
            case Multiply: {
                a.muli((Number)this.scalar);
                break;
            }
            case Divide: {
                a.divi((Number)this.scalar);
                break;
            }
            case Modulus: {
                a.fmodi((Number)this.scalar);
                break;
            }
            case ReverseSubtract: {
                a.rsubi((Number)this.scalar);
                break;
            }
            case ReverseDivide: {
                a.rdivi((Number)this.scalar);
                break;
            }
            case ScalarMin: {
                Transforms.min((INDArray)a, (double)this.scalar, (boolean)false);
                break;
            }
            case ScalarMax: {
                Transforms.max((INDArray)a, (double)this.scalar, (boolean)false);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown or not supported op: " + (Object)((Object)this.mathOp));
            }
        }
        Nd4j.getExecutioner().commit();
        return new NDArrayWritable(a);
    }

    @Override
    public String toString() {
        return "NDArrayScalarOpTransform(mathOp=" + (Object)((Object)this.mathOp) + ",scalar=" + this.scalar + ")";
    }

    @Override
    public Object map(Object input) {
        if (input instanceof INDArray) {
            return this.map(new NDArrayWritable((INDArray)input)).get();
        }
        throw new RuntimeException("Unsupported class: " + input.getClass());
    }

    public MathOp getMathOp() {
        return this.mathOp;
    }

    public double getScalar() {
        return this.scalar;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NDArrayScalarOpTransform)) {
            return false;
        }
        NDArrayScalarOpTransform other = (NDArrayScalarOpTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getScalar(), other.getScalar()) != 0) {
            return false;
        }
        MathOp this$mathOp = this.getMathOp();
        MathOp other$mathOp = other.getMathOp();
        return !(this$mathOp == null ? other$mathOp != null : !((Object)((Object)this$mathOp)).equals((Object)other$mathOp));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NDArrayScalarOpTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $scalar = Double.doubleToLongBits(this.getScalar());
        result = result * 59 + (int)($scalar >>> 32 ^ $scalar);
        MathOp $mathOp = this.getMathOp();
        result = result * 59 + ($mathOp == null ? 43 : ((Object)((Object)$mathOp)).hashCode());
        return result;
    }
}

