/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.string;

import org.datavec.api.transform.transform.string.BaseStringTransform;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class ChangeCaseStringTransform
extends BaseStringTransform {
    private final CaseType caseType;

    public ChangeCaseStringTransform(String column) {
        super(column);
        this.caseType = CaseType.LOWER;
    }

    public ChangeCaseStringTransform(@JsonProperty(value="column") String column, @JsonProperty(value="caseType") CaseType caseType) {
        super(column);
        this.caseType = caseType;
    }

    private String mapHelper(String input) {
        String result;
        switch (this.caseType) {
            case UPPER: {
                result = input.toUpperCase();
                break;
            }
            default: {
                result = input.toLowerCase();
            }
        }
        return result;
    }

    @Override
    public Text map(Writable writable) {
        return new Text(this.mapHelper(writable.toString()));
    }

    @Override
    public Object map(Object input) {
        return this.mapHelper(input.toString());
    }

    public static enum CaseType {
        LOWER,
        UPPER;

    }
}

