/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.string;

import java.util.Map;
import org.datavec.api.transform.transform.string.BaseStringTransform;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class StringMapTransform
extends BaseStringTransform {
    private final Map<String, String> map;

    public StringMapTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="map") Map<String, String> map) {
        super(columnName);
        this.map = map;
    }

    @Override
    public Text map(Writable writable) {
        String orig = writable.toString();
        if (this.map.containsKey(orig)) {
            return new Text(this.map.get(orig));
        }
        if (writable instanceof Text) {
            return (Text)writable;
        }
        return new Text(writable.toString());
    }

    @Override
    public Object map(Object input) {
        String orig = input.toString();
        if (this.map.containsKey(orig)) {
            return this.map.get(orig);
        }
        if (input instanceof String) {
            return input;
        }
        return orig;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringMapTransform)) {
            return false;
        }
        StringMapTransform other = (StringMapTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, String> this$map = this.getMap();
        Map<String, String> other$map = other.getMap();
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StringMapTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Map<String, String> $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    @Override
    public String toString() {
        return "StringMapTransform(map=" + this.getMap() + ")";
    }
}

