/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.writer.impl.misc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.writer.impl.FileRecordWriter;
import org.datavec.api.writable.ArrayWritable;
import org.datavec.api.writable.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVMLightRecordWriter
extends FileRecordWriter {
    private static final Logger log = LoggerFactory.getLogger(SVMLightRecordWriter.class);
    public static final String NAME_SPACE = SVMLightRecordWriter.class.getName();
    public static final String FEATURE_FIRST_COLUMN = NAME_SPACE + ".featureStartColumn";
    public static final String FEATURE_LAST_COLUMN = NAME_SPACE + ".featureEndColumn";
    public static final String ZERO_BASED_INDEXING = NAME_SPACE + ".zeroBasedIndexing";
    public static final String HAS_LABELS = NAME_SPACE + ".hasLabel";
    public static final String MULTILABEL = NAME_SPACE + ".multilabel";
    public static final String LABEL_FIRST_COLUMN = NAME_SPACE + ".labelStartColumn";
    public static final String LABEL_LAST_COLUMN = NAME_SPACE + ".labelEndColumn";
    public static final int UNLABELED = -1;
    protected int featureFirstColumn = 0;
    protected int featureLastColumn = -1;
    protected boolean zeroBasedIndexing = false;
    protected boolean hasLabel = true;
    protected boolean multilabel = false;
    protected int labelFirstColumn = -1;
    protected int labelLastColumn = -1;

    public SVMLightRecordWriter() {
    }

    public SVMLightRecordWriter(File path) throws FileNotFoundException {
        super(path);
    }

    public SVMLightRecordWriter(File path, boolean append) throws FileNotFoundException {
        super(path, append);
    }

    public SVMLightRecordWriter(Configuration conf) throws FileNotFoundException {
        super(conf);
        this.setConf(conf);
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.featureFirstColumn = conf.getInt(FEATURE_FIRST_COLUMN, 0);
        this.hasLabel = conf.getBoolean(HAS_LABELS, true);
        this.multilabel = conf.getBoolean(MULTILABEL, false);
        this.labelFirstColumn = conf.getInt(LABEL_FIRST_COLUMN, -1);
        this.labelLastColumn = conf.getInt(LABEL_LAST_COLUMN, -1);
        this.featureLastColumn = conf.getInt(FEATURE_LAST_COLUMN, this.labelFirstColumn > 0 ? this.labelFirstColumn - 1 : -1);
        this.zeroBasedIndexing = conf.getBoolean(ZERO_BASED_INDEXING, false);
    }

    @Override
    public void write(List<Writable> record) throws IOException {
        if (!record.isEmpty()) {
            double val;
            int j;
            Writable w;
            int i;
            ArrayList recordList;
            ArrayList arrayList = recordList = record instanceof List ? record : new ArrayList(record);
            if (this.hasLabel) {
                if (this.labelLastColumn < 0) {
                    this.labelLastColumn = record.size() - 1;
                }
                if (this.labelFirstColumn < 0) {
                    this.labelFirstColumn = this.featureLastColumn > 0 ? this.featureLastColumn + 1 : record.size() - 1;
                }
            }
            if (this.featureLastColumn < 0) {
                this.featureLastColumn = this.labelFirstColumn > 0 ? this.labelFirstColumn - 1 : recordList.size() - 1;
            }
            StringBuilder result = new StringBuilder();
            if (this.hasLabel) {
                int labelIndex = this.zeroBasedIndexing ? 0 : 1;
                for (i = this.labelFirstColumn; i <= this.labelLastColumn; ++i) {
                    w = (Writable)record.get(i);
                    if (w instanceof ArrayWritable) {
                        ArrayWritable arr = (ArrayWritable)w;
                        j = 0;
                        while ((long)j < arr.length()) {
                            val = arr.getDouble(j);
                            if (this.multilabel) {
                                if (val == 1.0) {
                                    result.append("," + labelIndex);
                                } else if (val != 0.0 && val != -1.0) {
                                    throw new NumberFormatException("Expect value -1, 0, or 1 for multilabel targets (found " + val + ")");
                                }
                            } else {
                                result.append("," + val);
                            }
                            ++labelIndex;
                            ++j;
                        }
                        continue;
                    }
                    if (this.multilabel) {
                        double val2 = Double.valueOf(w.toString());
                        if (val2 == 1.0) {
                            result.append("," + labelIndex);
                        } else if (val2 != 0.0 && val2 != -1.0) {
                            throw new NumberFormatException("Expect value -1, 0, or 1 for multilabel targets (found " + val2 + ")");
                        }
                    } else {
                        try {
                            int val3 = Integer.valueOf(w.toString());
                            result.append("," + val3);
                        }
                        catch (Exception e) {
                            double val4 = Double.valueOf(w.toString());
                            result.append("," + val4);
                        }
                    }
                    ++labelIndex;
                }
            } else {
                result.append(",-1");
            }
            int featureIndex = this.zeroBasedIndexing ? 0 : 1;
            for (i = this.featureFirstColumn; i <= this.featureLastColumn; ++i) {
                w = (Writable)record.get(i);
                if (w instanceof ArrayWritable) {
                    ArrayWritable arr = (ArrayWritable)w;
                    j = 0;
                    while ((long)j < arr.length()) {
                        val = arr.getDouble(j);
                        if (val != 0.0) {
                            result.append(" " + featureIndex);
                            result.append(":" + val);
                        }
                        ++featureIndex;
                        ++j;
                    }
                    continue;
                }
                double val5 = w.toDouble();
                if (val5 != 0.0) {
                    result.append(" " + featureIndex);
                    result.append(":" + val5);
                }
                ++featureIndex;
            }
            String line = result.substring(1).toString();
            this.out.write(line.getBytes());
            this.out.write("\n".getBytes());
        }
    }
}

